/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.filemonitor;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarUtil {
    public static void zipDir(String directory, String zipName) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipName)));
        String path = "";
        JarUtil.zipDir(directory, zos, path, Collections.<String>emptySet());
        zos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void jarDir(String directory, String zipName) throws IOException {
        JarOutputStream zos = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(zipName)));
        String path = "";
        File manFile = new File(directory, "META-INF/MANIFEST.MF");
        if (manFile.exists()) {
            byte[] readBuffer = new byte[8192];
            FileInputStream fis = new FileInputStream(manFile);
            try {
                ZipEntry anEntry = new ZipEntry("META-INF/MANIFEST.MF");
                zos.putNextEntry(anEntry);
                int bytesIn = fis.read(readBuffer);
                while (bytesIn != -1) {
                    zos.write(readBuffer, 0, bytesIn);
                    bytesIn = fis.read(readBuffer);
                }
            }
            finally {
                fis.close();
            }
            zos.closeEntry();
        }
        JarUtil.zipDir(directory, zos, path, Collections.singleton("META-INF/MANIFEST.MF"));
        zos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipDir(String directory, ZipOutputStream zos, String path, Set<String> exclusions) throws IOException {
        File zipDir = new File(directory);
        String[] dirList = zipDir.list();
        byte[] readBuffer = new byte[8192];
        int bytesIn = 0;
        for (int i = 0; i < dirList.length; ++i) {
            File f = new File(zipDir, dirList[i]);
            if (f.isDirectory()) {
                String filePath = f.getPath();
                JarUtil.zipDir(filePath, zos, path + f.getName() + "/", exclusions);
                continue;
            }
            String entry = path + f.getName();
            if (exclusions.contains(entry)) continue;
            FileInputStream fis = new FileInputStream(f);
            try {
                ZipEntry anEntry = new ZipEntry(entry);
                zos.putNextEntry(anEntry);
                bytesIn = fis.read(readBuffer);
                while (bytesIn != -1) {
                    zos.write(readBuffer, 0, bytesIn);
                    bytesIn = fis.read(readBuffer);
                }
                continue;
            }
            finally {
                fis.close();
            }
        }
    }
}

