/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.eip.support;

import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.servicemix.common.util.MessageUtil;
import org.apache.servicemix.eip.EIPEndpoint;
import org.apache.servicemix.eip.support.ExchangeTarget;

public abstract class AbstractContentBasedRouter
extends EIPEndpoint {
    private String correlation;
    private boolean forwardOperation;

    public boolean isForwardOperation() {
        return this.forwardOperation;
    }

    public void setForwardOperation(boolean forwardOperation) {
        this.forwardOperation = forwardOperation;
    }

    public void validate() throws DeploymentException {
        super.validate();
        this.correlation = "AbstractContentBasedRouter.Correlation." + this.getService() + "." + this.getEndpoint();
    }

    protected void processSync(MessageExchange exchange) throws Exception {
        MessageExchange tme = this.getExchangeFactory().createExchange(exchange.getPattern());
        NormalizedMessage in = MessageUtil.copyIn((MessageExchange)exchange);
        MessageUtil.transferToIn((NormalizedMessage)in, (MessageExchange)tme);
        ExchangeTarget target = this.getDestination(tme);
        target.configureTarget(tme, this.getContext());
        if (this.isForwardOperation() && tme.getOperation() == null) {
            tme.setOperation(exchange.getOperation());
        }
        this.sendSync(tme);
        if (tme.getStatus() == ExchangeStatus.DONE) {
            this.done(exchange);
        } else if (tme.getStatus() == ExchangeStatus.ERROR) {
            this.fail(exchange, tme.getError());
        } else if (tme.getFault() != null) {
            Fault fault = MessageUtil.copyFault((MessageExchange)tme);
            this.done(tme);
            MessageUtil.transferToFault((Fault)fault, (MessageExchange)exchange);
            this.sendSync(exchange);
        } else if (tme.getMessage("out") != null) {
            NormalizedMessage out = MessageUtil.copyOut((MessageExchange)tme);
            this.done(tme);
            MessageUtil.transferToOut((NormalizedMessage)out, (MessageExchange)exchange);
            this.sendSync(exchange);
        } else {
            this.done(tme);
            throw new IllegalStateException("Exchange status is " + ExchangeStatus.ACTIVE + " but has no Out nor Fault message");
        }
    }

    protected void processAsync(MessageExchange exchange) throws Exception {
        if (exchange.getRole() == MessageExchange.Role.PROVIDER && exchange.getProperty(this.correlation) == null) {
            MessageExchange tme = this.getExchangeFactory().createExchange(exchange.getPattern());
            if (this.store.hasFeature("Clustered")) {
                exchange.setProperty("org.apache.servicemix.provider.stateless", (Object)Boolean.TRUE);
                tme.setProperty("org.apache.servicemix.consumer.stateless", (Object)Boolean.TRUE);
            }
            tme.setProperty(this.correlation, (Object)exchange.getExchangeId());
            exchange.setProperty(this.correlation, (Object)tme.getExchangeId());
            this.store.store(exchange.getExchangeId(), (Object)exchange);
            try {
                NormalizedMessage in = MessageUtil.copyIn((MessageExchange)exchange);
                MessageUtil.transferToIn((NormalizedMessage)in, (MessageExchange)tme);
                ExchangeTarget target = this.getDestination(tme);
                target.configureTarget(tme, this.getContext());
                if (this.isForwardOperation() && tme.getOperation() == null) {
                    tme.setOperation(exchange.getOperation());
                }
                this.send(tme);
            }
            catch (Exception e) {
                this.store.load(exchange.getExchangeId());
                throw e;
            }
        } else {
            String id = (String)exchange.getProperty(this.correlation);
            if (id == null) {
                throw new IllegalStateException(this.correlation + " property not found");
            }
            MessageExchange org = (MessageExchange)this.store.load(id);
            if (org == null) {
                throw new IllegalStateException("Could not load original exchange with id " + id);
            }
            if (exchange.getStatus() == ExchangeStatus.DONE) {
                this.done(org);
            } else if (exchange.getStatus() == ExchangeStatus.ERROR) {
                this.fail(org, exchange.getError());
            } else if (exchange.getFault() != null) {
                this.store.store(exchange.getExchangeId(), (Object)exchange);
                try {
                    MessageUtil.transferTo((MessageExchange)exchange, (MessageExchange)org, (String)"fault");
                    this.send(org);
                }
                catch (Exception e) {
                    this.store.load(exchange.getExchangeId());
                    throw e;
                }
            } else if (exchange.getMessage("out") != null) {
                this.store.store(exchange.getExchangeId(), (Object)exchange);
                try {
                    MessageUtil.transferTo((MessageExchange)exchange, (MessageExchange)org, (String)"out");
                    this.send(org);
                }
                catch (Exception e) {
                    this.store.load(exchange.getExchangeId());
                    throw e;
                }
            } else {
                throw new IllegalStateException("Exchange status is " + ExchangeStatus.ACTIVE + " but has no Out nor Fault message");
            }
        }
    }

    protected abstract ExchangeTarget getDestination(MessageExchange var1) throws Exception;
}

