/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.eip.support;

import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.servicemix.common.util.URIResolver;
import org.springframework.beans.factory.InitializingBean;

public class ExchangeTarget
implements InitializingBean {
    private QName interf;
    private QName operation;
    private QName service;
    private String endpoint;
    private String uri;

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public QName getInterface() {
        return this.interf;
    }

    public void setInterface(QName itf) {
        this.interf = itf;
    }

    public QName getOperation() {
        return this.operation;
    }

    public void setOperation(QName operation) {
        this.operation = operation;
    }

    public QName getService() {
        return this.service;
    }

    public void setService(QName service) {
        this.service = service;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void configureTarget(MessageExchange exchange, ComponentContext context) throws MessagingException {
        if (this.interf == null && this.service == null && this.uri == null) {
            throw new MessagingException("interface, service or uri should be specified");
        }
        if (this.uri != null) {
            URIResolver.configureExchange((MessageExchange)exchange, (ComponentContext)context, (String)this.uri);
        }
        if (this.interf != null) {
            exchange.setInterfaceName(this.interf);
        }
        if (this.operation != null) {
            exchange.setOperation(this.operation);
        }
        if (this.service != null) {
            exchange.setService(this.service);
            if (this.endpoint != null) {
                ServiceEndpoint se = context.getEndpoint(this.service, this.endpoint);
                exchange.setEndpoint(se);
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.interf == null && this.service == null && this.uri == null) {
            throw new MessagingException("interface, service or uri should be specified");
        }
    }
}

