/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.eip.support.resequence;

import java.net.URI;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.messaging.RobustInOnly;
import org.apache.servicemix.common.util.MessageUtil;
import org.apache.servicemix.eip.EIPEndpoint;
import org.apache.servicemix.eip.support.ExchangeTarget;
import org.apache.servicemix.jbi.transformer.CopyTransformer;
import org.apache.servicemix.jbi.transformer.MessageTransformer;

public abstract class ResequencerBase
extends EIPEndpoint {
    private MessageTransformer messageCopier = new CopyTransformer();
    private ExchangeTarget target;

    public MessageTransformer getMessageCopier() {
        return this.messageCopier;
    }

    public ExchangeTarget getTarget() {
        return this.target;
    }

    public void setTarget(ExchangeTarget target) {
        this.target = target;
    }

    public void validate() throws DeploymentException {
        super.validate();
        if (this.target == null) {
            throw new IllegalArgumentException("target must be set to a valid ExchangeTarget");
        }
    }

    public void validateMessageExchange(MessageExchange exchange) throws MessagingException {
        if (exchange instanceof InOnly || exchange instanceof RobustInOnly) {
            return;
        }
        this.fail(exchange, new UnsupportedOperationException("Use an InOnly or RobustInOnly MEP"));
    }

    protected MessageExchange createTargetExchange(NormalizedMessage message, URI exchangePattern) throws MessagingException {
        MessageExchange targetExchange = this.getExchangeFactory().createExchange(exchangePattern);
        this.target.configureTarget(targetExchange, this.getContext());
        MessageUtil.transferToIn((NormalizedMessage)message, (MessageExchange)targetExchange);
        return targetExchange;
    }
}

