/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.mail;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jbi.JBIException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.mail.Authenticator;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.ParseException;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchTerm;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.common.endpoints.PollingEndpoint;
import org.apache.servicemix.mail.MailEndpointType;
import org.apache.servicemix.mail.marshaler.AbstractMailMarshaler;
import org.apache.servicemix.mail.marshaler.DefaultMailMarshaler;
import org.apache.servicemix.mail.utils.MailConnectionConfiguration;
import org.apache.servicemix.mail.utils.MailUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailPollerEndpoint
extends PollingEndpoint
implements MailEndpointType {
    private static final transient Log LOG = LogFactory.getLog(MailPollerEndpoint.class);
    private AbstractMailMarshaler marshaler = new DefaultMailMarshaler();
    private List<String> seenMessages = Collections.synchronizedList(new LinkedList());
    private String customTrustManagers;
    private MailConnectionConfiguration config;
    private String connection;
    private int maxFetchSize = -1;
    private boolean processOnlyUnseenMessages = true;
    private boolean deleteProcessedMessages = false;
    private boolean debugMode = false;
    private Map<String, String> customProperties;
    private List<String> foundMessagesInFolder = Collections.synchronizedList(new LinkedList());
    private org.apache.servicemix.store.Store storage;

    public String getLocationURI() {
        return this.getService() + "#" + this.getEndpoint();
    }

    public synchronized void start() throws Exception {
        super.start();
        if (this.storage != null) {
            String id = this.config.getUsername() + " @ " + this.config.getHost();
            try {
                List loadedMsg = (List)this.storage.load(id);
                if (loadedMsg != null && !loadedMsg.isEmpty()) {
                    for (String uid : loadedMsg) {
                        if (this.seenMessages.contains(uid)) continue;
                        this.seenMessages.add(uid);
                    }
                    loadedMsg.clear();
                }
            }
            catch (IOException ioex) {
                this.logger.error((Object)("Error loading seen messages for: " + id), (Throwable)ioex);
            }
        }
    }

    public synchronized void stop() throws Exception {
        if (this.storage != null) {
            String id = this.config.getUsername() + " @ " + this.config.getHost();
            try {
                this.storage.store(id, this.seenMessages);
            }
            catch (IOException ioex) {
                this.logger.error((Object)("Error saving list of seen messages for: " + id), (Throwable)ioex);
            }
        }
        super.stop();
    }

    public void process(MessageExchange exchange) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poll() throws Exception {
        LOG.debug((Object)("Polling mailfolder " + this.config.getFolderName() + " at host " + this.config.getHost() + "..."));
        if (this.maxFetchSize == 0) {
            LOG.debug((Object)"The configuration is set to poll no new messages at all...skipping.");
            return;
        }
        boolean isPopProtocol = this.config.getProtocol().toLowerCase().indexOf("pop") > -1;
        this.foundMessagesInFolder.clear();
        Store store = null;
        Folder folder = null;
        Session session = null;
        try {
            Properties props = MailUtils.getPropertiesForProtocol(this.config, this.customTrustManagers);
            props.put("mail.debug", this.isDebugMode() ? "true" : "false");
            this.applyCustomProperties(props);
            session = Session.getInstance((Properties)props, (Authenticator)this.config.getAuthenticator());
            session.setDebug(this.debugMode);
            store = session.getStore(this.config.getProtocol());
            store.connect(this.config.getHost(), this.config.getUsername(), this.config.getPassword());
            folder = store.getFolder(this.config.getFolderName());
            if (folder == null || !folder.exists()) {
                throw new Exception("Folder not found or invalid: " + this.config.getFolderName());
            }
            folder.open(2);
            Message[] messages = null;
            messages = this.isProcessOnlyUnseenMessages() && !isPopProtocol ? folder.search((SearchTerm)new FlagTerm(new Flags(Flags.Flag.SEEN), false)) : folder.getMessages();
            int fetchSize = this.getMaxFetchSize() == -1 ? messages.length : Math.min(this.getMaxFetchSize(), messages.length);
            int fetchedMessages = 0;
            String uid = null;
            for (int cnt = 0; cnt < messages.length; ++cnt) {
                uid = null;
                MimeMessage mailMsg = (MimeMessage)messages[cnt];
                if (this.isProcessOnlyUnseenMessages() && isPopProtocol) {
                    try {
                        Object o_uid = folder.getClass().getMethod("getUID", Message.class).invoke((Object)folder, mailMsg);
                        if (o_uid != null) {
                            uid = (String)o_uid;
                            this.foundMessagesInFolder.add(uid);
                        }
                        if (uid != null && this.seenMessages.contains(uid)) {
                            continue;
                        }
                    }
                    catch (Exception ex) {
                        this.logger.warn((Object)(this.getEndpoint() + ": Unable to determine unique id of mail."), (Throwable)ex);
                    }
                }
                if (fetchedMessages >= fetchSize) continue;
                InOnly io = this.getExchangeFactory().createInOnlyExchange();
                this.configureExchangeTarget((MessageExchange)io);
                NormalizedMessage normalizedMessage = io.createMessage();
                this.marshaler.convertMailToJBI((MessageExchange)io, normalizedMessage, mailMsg);
                io.setInMessage(normalizedMessage);
                this.sendSync((MessageExchange)io);
                ++fetchedMessages;
                if (io.getStatus() == ExchangeStatus.ERROR) {
                    Throwable e = io.getError();
                    if (e == null) {
                        e = new JBIException("Unexpected error occured...");
                    }
                    throw e;
                }
                if (this.deleteProcessedMessages) {
                    mailMsg.setFlag(Flags.Flag.DELETED, true);
                } else {
                    mailMsg.setFlag(Flags.Flag.SEEN, true);
                }
                if (!this.isProcessOnlyUnseenMessages() || !isPopProtocol || uid == null) continue;
                this.seenMessages.add(uid);
            }
        }
        finally {
            try {
                if (folder != null) {
                    folder.close(true);
                }
                if (store != null) {
                    store.close();
                }
                if (this.isProcessOnlyUnseenMessages() && isPopProtocol) {
                    this.cleanUpSeenMessages();
                }
            }
            catch (Exception ignored) {
                this.logger.debug((Object)ignored);
            }
        }
    }

    private synchronized void cleanUpSeenMessages() {
        LinkedList<String> uidsToRemove = new LinkedList<String>();
        for (String uid : this.seenMessages) {
            if (this.foundMessagesInFolder.contains(uid)) continue;
            uidsToRemove.add(uid);
        }
        for (String uid : uidsToRemove) {
            this.seenMessages.remove(uid);
        }
    }

    private void applyCustomProperties(Properties props) {
        if (this.customProperties != null) {
            props.putAll(this.customProperties);
        }
    }

    public boolean isDeleteProcessedMessages() {
        return this.deleteProcessedMessages;
    }

    public void setDeleteProcessedMessages(boolean deleteProcessedMessages) {
        this.deleteProcessedMessages = deleteProcessedMessages;
    }

    public AbstractMailMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(AbstractMailMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public int getMaxFetchSize() {
        return this.maxFetchSize;
    }

    public void setMaxFetchSize(int maxFetchSize) {
        this.maxFetchSize = maxFetchSize;
    }

    public boolean isProcessOnlyUnseenMessages() {
        return this.processOnlyUnseenMessages;
    }

    public void setProcessOnlyUnseenMessages(boolean processOnlyUnseenMessages) {
        this.processOnlyUnseenMessages = processOnlyUnseenMessages;
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
        try {
            this.config = MailUtils.configure(this.connection);
        }
        catch (ParseException ex) {
            LOG.error((Object)"The configured connection uri is invalid", (Throwable)ex);
        }
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public String getCustomTrustManagers() {
        return this.customTrustManagers;
    }

    public void setCustomTrustManagers(String customTrustManagers) {
        this.customTrustManagers = customTrustManagers;
    }

    public Map<String, String> getCustomProperties() {
        return this.customProperties;
    }

    public void setCustomProperties(Map<String, String> customProperties) {
        this.customProperties = customProperties;
    }

    public org.apache.servicemix.store.Store getStorage() {
        return this.storage;
    }

    public void setStorage(org.apache.servicemix.store.Store storage) {
        this.storage = storage;
    }
}

