/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.osgi.compendium.internal.OsgiConfig;
import org.springframework.osgi.config.ParserUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

class OsgiConfigDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    public static final String PERSISTENT_ID = "persistent-id";
    public static final String CONFIG_LISTENER = "config-listener";
    public static final String FACTORY = "isFactory";
    public static final String REF = "ref";
    public static final String UPDATE_METHOD = "update-method";
    public static final String DELETED_METHOD = "deleted-method";
    public static final String PERSISTENT_ID_FIELD = "pid";
    public static final String LISTENERS_FIELD = "listeners";
    public static final String FACTORY_FIELD = "factory";

    OsgiConfigDefinitionParser() {
    }

    protected Class getBeanClass(Element element) {
        return OsgiConfig.class;
    }

    protected boolean shouldGenerateId() {
        return true;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        ParserUtils.parseCustomAttributes(element, builder, new ParserUtils.AttributeCallback(){

            public boolean process(Element parent, Attr attribute, BeanDefinitionBuilder builder) {
                String name = attribute.getLocalName();
                String value = attribute.getValue();
                if (OsgiConfigDefinitionParser.PERSISTENT_ID.equals(name)) {
                    builder.addPropertyValue(OsgiConfigDefinitionParser.PERSISTENT_ID_FIELD, (Object)value);
                    return false;
                }
                if (OsgiConfigDefinitionParser.FACTORY.equals(name)) {
                    builder.addPropertyValue(OsgiConfigDefinitionParser.FACTORY_FIELD, (Object)value);
                    return false;
                }
                return true;
            }
        });
        ArrayList<OsgiConfig.ConfigListener> configListeners = new ArrayList<OsgiConfig.ConfigListener>();
        List nestedElements = DomUtils.getChildElementsByTagName((Element)element, (String)CONFIG_LISTENER);
        Iterator listeners = nestedElements.iterator();
        while (listeners.hasNext()) {
            Element listener = (Element)listeners.next();
            if (!listener.hasAttribute(REF)) {
                parserContext.getReaderContext().error("ref' attribute is not specified", (Object)element);
            }
            if (!listener.hasAttribute(UPDATE_METHOD)) {
                parserContext.getReaderContext().error("update-method' attribute is not specified", (Object)element);
            }
            OsgiConfig.ConfigListener l = new OsgiConfig.ConfigListener();
            l.setReference(listener.getAttribute(REF));
            l.setUpdateMethod(listener.getAttribute(UPDATE_METHOD));
            if (listener.hasAttribute(DELETED_METHOD)) {
                l.setDeletedMethod(listener.getAttribute(DELETED_METHOD));
            }
            configListeners.add(l);
        }
        builder.addPropertyValue(LISTENERS_FIELD, configListeners);
    }
}

