/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.context.support;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.support.AbstractRefreshableApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.osgi.context.BundleContextAware;
import org.springframework.osgi.context.ConfigurableOsgiBundleApplicationContext;
import org.springframework.osgi.context.internal.classloader.AopClassLoaderFactory;
import org.springframework.osgi.context.support.BundleContextAwareProcessor;
import org.springframework.osgi.context.support.OsgiPropertyEditorRegistrar;
import org.springframework.osgi.context.support.internal.OsgiBundleScope;
import org.springframework.osgi.io.OsgiBundleResource;
import org.springframework.osgi.io.OsgiBundleResourcePatternResolver;
import org.springframework.osgi.util.OsgiBundleUtils;
import org.springframework.osgi.util.OsgiServiceUtils;
import org.springframework.osgi.util.OsgiStringUtils;
import org.springframework.osgi.util.internal.MapBasedDictionary;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractOsgiBundleApplicationContext
extends AbstractRefreshableApplicationContext
implements ConfigurableOsgiBundleApplicationContext {
    private static final String EXPORTER_IMPORTER_DEPENDENCY_MANAGER = "org.springframework.osgi.service.dependency.internal.MandatoryDependencyBeanPostProcessor";
    private Bundle bundle;
    private BundleContext bundleContext;
    private String[] configLocations;
    private ServiceRegistration serviceRegistration;
    private boolean publishContextAsService = true;
    private ClassLoader classLoader;
    private ResourcePatternResolver osgiPatternResolver;

    public AbstractOsgiBundleApplicationContext() {
        this.setDisplayName("Root OsgiBundleApplicationContext");
    }

    public AbstractOsgiBundleApplicationContext(ApplicationContext parent) {
        super(parent);
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.bundle = bundleContext.getBundle();
        this.osgiPatternResolver = this.createResourcePatternResolver();
        if (this.getClassLoader() == null) {
            this.setClassLoader(this.createBundleClassLoader(this.bundle));
        }
        this.setDisplayName(ClassUtils.getShortName(this.getClass()) + "(bundle=" + this.getBundleSymbolicName() + ", config=" + StringUtils.arrayToCommaDelimitedString((Object[])this.getConfigLocations()) + ")");
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public void setConfigLocations(String[] configLocations) {
        this.configLocations = configLocations;
    }

    public String[] getConfigLocations() {
        return this.configLocations != null ? this.configLocations : this.getDefaultConfigLocations();
    }

    protected void doClose() {
        if (!OsgiServiceUtils.unregisterService(this.serviceRegistration)) {
            this.logger.info((Object)("Unpublishing application context OSGi service for bundle " + OsgiStringUtils.nullSafeNameAndSymName(this.bundle)));
            this.serviceRegistration = null;
        } else if (this.publishContextAsService) {
            this.logger.info((Object)"Application Context service already unpublished");
        }
        super.doClose();
    }

    protected void destroyBeans() {
        super.destroyBeans();
        try {
            this.cleanOsgiBundleScope(this.getBeanFactory());
        }
        catch (Exception ex) {
            this.logger.warn((Object)"got exception when closing", (Throwable)ex);
        }
    }

    protected String[] getDefaultConfigLocations() {
        return null;
    }

    protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        super.postProcessBeanFactory(beanFactory);
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new BundleContextAwareProcessor(this.bundleContext));
        beanFactory.ignoreDependencyInterface(BundleContextAware.class);
        this.enforceExporterImporterDependency(beanFactory);
        if (!beanFactory.containsLocalBean("bundleContext")) {
            this.logger.debug((Object)"Registering BundleContext as a bean named bundleContext");
            beanFactory.registerSingleton("bundleContext", (Object)this.bundleContext);
        } else {
            this.logger.warn((Object)"A bean named bundleContext already exists; the bundleContext will not be registered as a bean");
        }
        this.registerPropertyEditors(beanFactory);
        beanFactory.registerScope("bundle", (Scope)new OsgiBundleScope());
    }

    private void enforceExporterImporterDependency(ConfigurableListableBeanFactory beanFactory) {
        ClassLoader loader = AbstractOsgiBundleApplicationContext.class.getClassLoader();
        Object instance = null;
        try {
            Class<?> managerClass = loader.loadClass(EXPORTER_IMPORTER_DEPENDENCY_MANAGER);
            instance = BeanUtils.instantiateClass(managerClass);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ApplicationContextException("Cannot load class org.springframework.osgi.service.dependency.internal.MandatoryDependencyBeanPostProcessor", (Throwable)cnfe);
        }
        Assert.isInstanceOf((Class)BeanFactoryAware.class, (Object)instance);
        Assert.isInstanceOf((Class)BeanPostProcessor.class, (Object)instance);
        ((BeanFactoryAware)instance).setBeanFactory((BeanFactory)beanFactory);
        beanFactory.addBeanPostProcessor((BeanPostProcessor)instance);
    }

    private void registerPropertyEditors(ConfigurableListableBeanFactory beanFactory) {
        beanFactory.addPropertyEditorRegistrar((PropertyEditorRegistrar)new OsgiPropertyEditorRegistrar());
    }

    private void cleanOsgiBundleScope(ConfigurableListableBeanFactory beanFactory) {
        Scope scope = beanFactory.getRegisteredScope("bundle");
        if (scope != null && scope instanceof OsgiBundleScope) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Destroying existing bundle scope beans...");
            }
            ((OsgiBundleScope)scope).destroy();
        }
    }

    void publishContextAsOsgiServiceIfNecessary() {
        if (this.publishContextAsService) {
            MapBasedDictionary serviceProperties = new MapBasedDictionary();
            this.customizeApplicationContextServiceProperties(serviceProperties);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Publishing application context as OSGi service with properties " + serviceProperties));
            }
            Class[] classes = org.springframework.osgi.util.internal.ClassUtils.getClassHierarchy(this.getClass(), 1);
            Class[] filterClasses = org.springframework.osgi.util.internal.ClassUtils.getVisibleClasses(classes, this.getClass().getClassLoader());
            Object[] serviceNames = org.springframework.osgi.util.internal.ClassUtils.toStringArray(filterClasses);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Publishing service under classes " + ObjectUtils.nullSafeToString((Object[])serviceNames)));
            }
            this.serviceRegistration = this.getBundleContext().registerService((String[])serviceNames, (Object)this, (Dictionary)serviceProperties);
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Not publishing application context OSGi service for bundle " + OsgiStringUtils.nullSafeNameAndSymName(this.bundle)));
        }
    }

    protected void customizeApplicationContextServiceProperties(Map serviceProperties) {
        serviceProperties.put("org.springframework.context.service.name", this.getBundleSymbolicName());
        serviceProperties.put("Bundle-SymbolicName", this.getBundleSymbolicName());
        serviceProperties.put("Bundle-Version", OsgiBundleUtils.getBundleVersion(this.bundle));
    }

    private String getBundleSymbolicName() {
        return OsgiStringUtils.nullSafeSymbolicName(this.getBundle());
    }

    protected ResourcePatternResolver createResourcePatternResolver() {
        return new OsgiBundleResourcePatternResolver(this.getBundle());
    }

    protected ResourcePatternResolver getResourcePatternResolver() {
        return this.osgiPatternResolver;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Resource getResource(String location) {
        return this.osgiPatternResolver != null ? this.osgiPatternResolver.getResource(location) : null;
    }

    public Resource[] getResources(String locationPattern) throws IOException {
        return this.osgiPatternResolver != null ? this.osgiPatternResolver.getResources(locationPattern) : null;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected Resource getResourceByPath(String path) {
        Assert.notNull((Object)path, (String)"Path is required");
        return new OsgiBundleResource(this.bundle, path);
    }

    public void setPublishContextAsService(boolean publishContextAsService) {
        this.publishContextAsService = publishContextAsService;
    }

    private ClassLoader createBundleClassLoader(Bundle bundle) {
        return AopClassLoaderFactory.getBundleClassLoaderFor(bundle);
    }
}

