/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.importer.support;

import java.util.LinkedHashSet;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.springframework.osgi.context.internal.classloader.AopClassLoaderFactory;
import org.springframework.osgi.service.importer.support.AbstractServiceProxyCreator;
import org.springframework.osgi.service.importer.support.ImportContextClassLoader;
import org.springframework.osgi.service.importer.support.internal.aop.ServiceInvoker;
import org.springframework.osgi.service.importer.support.internal.aop.ServiceStaticInterceptor;
import org.springframework.osgi.service.util.internal.aop.ServiceTCCLInterceptor;
import org.springframework.osgi.util.OsgiServiceReferenceUtils;
import org.springframework.osgi.util.OsgiStringUtils;
import org.springframework.osgi.util.internal.ClassUtils;
import org.springframework.util.ObjectUtils;

class StaticServiceProxyCreator
extends AbstractServiceProxyCreator {
    private static final Log log = LogFactory.getLog((Class)StaticServiceProxyCreator.class);
    private final boolean greedyProxying;
    private final boolean interfacesOnlyProxying;

    StaticServiceProxyCreator(Class[] classes, ClassLoader classLoader, BundleContext bundleContext, ImportContextClassLoader iccl, boolean greedyProxying) {
        super(classes, classLoader, bundleContext, iccl);
        String msg;
        this.greedyProxying = greedyProxying;
        boolean onlyInterfaces = true;
        for (int i = 0; i < classes.length; ++i) {
            if (classes[i].isInterface()) continue;
            onlyInterfaces = false;
        }
        this.interfacesOnlyProxying = onlyInterfaces;
        String string = msg = this.interfacesOnlyProxying ? "NOT" : "";
        if (log.isDebugEnabled()) {
            log.debug((Object)("Greedy proxying will " + msg + " consider exposed classes"));
        }
    }

    ServiceInvoker createDispatcherInterceptor(ServiceReference reference) {
        return new ServiceStaticInterceptor(this.bundleContext, reference);
    }

    Advice createServiceProviderTCCLAdvice(ServiceReference reference) {
        Bundle bundle = reference.getBundle();
        if (bundle == null) {
            return null;
        }
        return new ServiceTCCLInterceptor(AopClassLoaderFactory.getBundleClassLoaderFor(bundle));
    }

    Class[] discoverProxyClasses(ServiceReference ref) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("Generating greedy proxy for service " + OsgiStringUtils.nullSafeToString(ref)));
        }
        Object[] classNames = OsgiServiceReferenceUtils.getServiceObjectClasses(ref);
        if (trace) {
            log.trace((Object)("Discovered raw classes " + ObjectUtils.nullSafeToString((Object[])classNames)));
        }
        Object[] classes = ClassUtils.loadClasses((String[])classNames, this.classLoader);
        if (trace) {
            log.trace((Object)("Visible classes are " + ObjectUtils.nullSafeToString((Object[])classes)));
        }
        classes = ClassUtils.excludeClassesWithModifier((Class[])classes, 16);
        if (trace) {
            log.trace((Object)("Filtering out final classes; left out with " + ObjectUtils.nullSafeToString((Object[])classes)));
        }
        if (this.interfacesOnlyProxying) {
            LinkedHashSet<Object> clazzes = new LinkedHashSet<Object>(classes.length);
            for (int classIndex = 0; classIndex < classes.length; ++classIndex) {
                Object clazz = classes[classIndex];
                if (!((Class)clazz).isInterface()) continue;
                clazzes.add(clazz);
            }
            if (trace) {
                log.trace((Object)("Filtering out concrete classes; left out with " + clazzes));
            }
            classes = clazzes.toArray(new Class[clazzes.size()]);
        }
        classes = ClassUtils.removeParents((Class[])classes);
        if (trace) {
            log.trace((Object)("Filtering out parent classes; left out with " + classes));
        }
        return classes;
    }

    Class[] getInterfaces(ServiceReference reference) {
        if (this.greedyProxying) {
            Object[] clazzes = this.discoverProxyClasses(reference);
            if (log.isTraceEnabled()) {
                log.trace((Object)("generating 'greedy' service proxy using classes " + ObjectUtils.nullSafeToString((Object[])clazzes) + " over " + ObjectUtils.nullSafeToString((Object[])this.classes)));
            }
            return clazzes;
        }
        return this.classes;
    }
}

