/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.importer.support.internal.support;

import org.springframework.osgi.service.importer.support.internal.support.RetryCallback;
import org.springframework.util.Assert;

public class RetryTemplate {
    private static final int hashCode = RetryTemplate.class.hashCode() * 13;
    public static final long DEFAULT_WAIT_TIME = 1000L;
    public static final int DEFAULT_RETRY_NUMBER = 3;
    private long waitTime = 1000L;
    private int retryNumbers = 3;

    public RetryTemplate() {
        this(null);
    }

    public RetryTemplate(int retryNumbers, long waitTime) {
        Assert.isTrue((retryNumbers >= 0 ? 1 : 0) != 0, (String)"retryNumbers must be positive");
        Assert.isTrue((waitTime >= 0L ? 1 : 0) != 0, (String)"waitTime must be positive");
        this.retryNumbers = retryNumbers;
        this.waitTime = waitTime;
    }

    public RetryTemplate(RetryTemplate template) {
        this(template != null ? template.getRetryNumbers() : 3, template != null ? template.getWaitTime() : 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(RetryCallback callback, Object notificationLock) {
        Assert.notNull((Object)callback, (String)"callback is required");
        Assert.notNull((Object)notificationLock, (String)"notificationLock is required");
        int count = 0;
        Object object = notificationLock;
        synchronized (object) {
            do {
                Object result;
                if (callback.isComplete(result = callback.doWithRetry())) {
                    return result;
                }
                ++count;
                if (this.waitTime == 0L) continue;
                try {
                    notificationLock.wait(this.waitTime);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException("retry failed; interrupted while sleeping", ex);
                }
            } while (count < this.retryNumbers);
        }
        return null;
    }

    public Object execute(RetryCallback callback) {
        return this.execute(callback, this);
    }

    public int getRetryNumbers() {
        return this.retryNumbers;
    }

    public void setRetryNumbers(int retryNumbers) {
        this.retryNumbers = retryNumbers;
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(long waitTime) {
        this.waitTime = waitTime;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof RetryTemplate) {
            RetryTemplate oth = (RetryTemplate)other;
            return this.waitTime == oth.waitTime && this.retryNumbers == oth.retryNumbers;
        }
        return false;
    }

    public int hashCode() {
        return hashCode;
    }
}

