/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Constants {
    private static final Properties properties = new Properties();
    public static final String PLATFORM = "java";
    public static final int MARSHAL_MAJOR = 4;
    public static final int MARSHAL_MINOR = 8;
    public static final String RUBY_MAJOR_VERSION;
    public static final String RUBY_VERSION;
    public static final String RUBY1_9_MAJOR_VERSION;
    public static final String RUBY1_9_VERSION;
    public static final String RUBY_PATCHLEVEL;
    public static final String COMPILE_DATE;
    public static final String VERSION;
    public static final String BUILD;
    public static final String TARGET;
    public static final String REVISION;
    public static final String ENGINE = "jruby";
    public static final String JRUBY_PROPERTIES = "/org/jruby/jruby.properties";

    private Constants() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream stream = null;
        try {
            stream = Constants.class.getResourceAsStream(JRUBY_PROPERTIES);
            if (stream == null) {
                throw new RuntimeException("Resource not found: /org/jruby/jruby.properties");
            }
            properties.load(stream);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
        RUBY_MAJOR_VERSION = properties.getProperty("version.ruby.major");
        RUBY_VERSION = properties.getProperty("version.ruby");
        RUBY1_9_MAJOR_VERSION = properties.getProperty("version.ruby1_9.major");
        RUBY1_9_VERSION = properties.getProperty("version.ruby1_9");
        COMPILE_DATE = properties.getProperty("release.date");
        VERSION = properties.getProperty("version.jruby");
        BUILD = properties.getProperty("build.jruby");
        TARGET = properties.getProperty("target.jruby");
        Matcher matcher = Pattern.compile("\\$Revision: (.*?) \\$").matcher(properties.getProperty("revision.jruby"));
        REVISION = matcher.find() ? matcher.group(1) : "0000";
        RUBY_PATCHLEVEL = REVISION;
    }
}

