/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.math.BigInteger;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.common.IRubyWarnings;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Convert;
import org.jruby.util.TypeConverter;

public class Sprintf {
    private static final int FLAG_NONE = 0;
    private static final int FLAG_SPACE = 1;
    private static final int FLAG_ZERO = 2;
    private static final int FLAG_PLUS = 4;
    private static final int FLAG_MINUS = 8;
    private static final int FLAG_SHARP = 16;
    private static final int FLAG_WIDTH = 32;
    private static final int FLAG_PRECISION = 64;
    private static final byte[] PREFIX_OCTAL = new byte[]{48};
    private static final byte[] PREFIX_HEX_LC = new byte[]{48, 120};
    private static final byte[] PREFIX_HEX_UC = new byte[]{48, 88};
    private static final byte[] PREFIX_BINARY_LC = new byte[]{48, 98};
    private static final byte[] PREFIX_BINARY_UC = new byte[]{48, 66};
    private static final byte[] PREFIX_NEGATIVE = new byte[]{46, 46};
    private static final byte[] NAN_VALUE = new byte[]{78, 97, 78};
    private static final byte[] INFINITY_VALUE = new byte[]{73, 110, 102};
    private static final BigInteger BIG_32 = BigInteger.valueOf(0x100000000L);
    private static final BigInteger BIG_64 = BIG_32.shiftLeft(32);
    private static final BigInteger BIG_MINUS_32 = BigInteger.valueOf(-4294967296L);
    private static final BigInteger BIG_MINUS_64 = BIG_MINUS_32.shiftLeft(32);
    private static final int INITIAL_BUFFER_SIZE = 32;
    private static final String ERR_MALFORMED_FORMAT = "malformed format string";
    private static final String ERR_MALFORMED_NUM = "malformed format string - %[0-9]";
    private static final String ERR_MALFORMED_DOT_NUM = "malformed format string - %.[0-9]";
    private static final String ERR_MALFORMED_STAR_NUM = "malformed format string - %*[0-9]";
    private static final String ERR_ILLEGAL_FORMAT_CHAR = "illegal format character - %";

    private Sprintf() {
    }

    public static CharSequence sprintf(Locale locale, CharSequence format, IRubyObject args) {
        return Sprintf.rubySprintf(format, new Args(locale, args));
    }

    public static RubyString sprintf(Ruby runtime, Locale locale, CharSequence format, IRubyObject args) {
        Buffer b = Sprintf.rubySprintfToBuffer(format, new Args(locale, args));
        RubyString s = runtime.newString(b.toByteList());
        if (b.tainted) {
            s.setTaint(true);
        }
        return s;
    }

    public static CharSequence sprintf(CharSequence format, IRubyObject args) {
        return Sprintf.rubySprintf(format, new Args(args));
    }

    public static CharSequence sprintf(Ruby runtime, CharSequence format, int arg) {
        return Sprintf.rubySprintf(format, new Args(runtime, arg));
    }

    public static CharSequence sprintf(Ruby runtime, CharSequence format, long arg) {
        return Sprintf.rubySprintf(format, new Args(runtime, arg));
    }

    public static CharSequence sprintf(Locale locale, RubyString format, IRubyObject args) {
        return Sprintf.rubySprintf(format.getByteList(), new Args(locale, args));
    }

    public static CharSequence sprintf(RubyString format, IRubyObject args) {
        return Sprintf.rubySprintf(format.getByteList(), new Args(args));
    }

    private static CharSequence rubySprintf(CharSequence charFormat, Args args) {
        return Sprintf.rubySprintfToBuffer(charFormat, args).toByteList();
    }

    /*
     * Unable to fully structure code
     */
    private static Buffer rubySprintfToBuffer(CharSequence charFormat, Args args) {
        buf = new Buffer();
        if (charFormat instanceof ByteList) {
            list = (ByteList)charFormat;
            format = list.unsafeBytes();
            offset = begin = list.begin();
            length = begin + list.length();
            start = begin;
            mark = begin;
        } else {
            format = Sprintf.stringToBytes(charFormat, false);
            offset = 0;
            length = charFormat.length();
            start = 0;
            mark = 0;
        }
        while (offset < length) {
            start = offset;
            while (offset < length && format[offset] != 37) {
                ++offset;
            }
            if (offset > start) {
                buf.write(format, start, offset - start);
                start = offset;
            }
            if (offset++ >= length) break;
            arg = null;
            flags = 0;
            width = 0;
            precision = 0;
            number = 0;
            fchar = 0;
            incomplete = true;
            block59: while (incomplete && offset < length) {
                fchar = format[offset];
                switch (fchar) {
                    default: {
                        if (fchar == 0 && flags == 0) {
                            buf.write(37);
                            buf.write(fchar);
                            incomplete = false;
                            ++offset;
                            continue block59;
                        }
                        if (Sprintf.isPrintable(fchar)) {
                            Sprintf.raiseArgumentError(args, "malformed format string - %" + (char)fchar);
                            continue block59;
                        }
                        Sprintf.raiseArgumentError(args, "malformed format string");
                        continue block59;
                    }
                    case 32: {
                        flags |= 1;
                        ++offset;
                        continue block59;
                    }
                    case 48: {
                        flags |= 2;
                        ++offset;
                        continue block59;
                    }
                    case 43: {
                        flags |= 4;
                        ++offset;
                        continue block59;
                    }
                    case 45: {
                        flags |= 8;
                        ++offset;
                        continue block59;
                    }
                    case 35: {
                        flags |= 16;
                        ++offset;
                        continue block59;
                    }
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        number = 0;
                        while (offset < length && Sprintf.isDigit(fchar = format[offset])) {
                            number = Sprintf.extendWidth(args, number, fchar);
                            ++offset;
                        }
                        Sprintf.checkOffset(args, offset, length, "malformed format string - %[0-9]");
                        if (fchar == 36) {
                            if (arg != null) {
                                Sprintf.raiseArgumentError(args, "value given twice - " + number + "$");
                            }
                            arg = args.getNth(number);
                            ++offset;
                            continue block59;
                        }
                        width = number;
                        flags |= 32;
                        continue block59;
                    }
                    case 42: {
                        if ((flags & 32) != 0) {
                            Sprintf.raiseArgumentError(args, "width given twice");
                        }
                        flags |= 32;
                        Sprintf.checkOffset(args, ++offset, length, "malformed format string - %*[0-9]");
                        mark = offset;
                        number = 0;
                        while (offset < length && Sprintf.isDigit(fchar = format[offset])) {
                            number = Sprintf.extendWidth(args, number, fchar);
                            ++offset;
                        }
                        Sprintf.checkOffset(args, offset, length, "malformed format string - %*[0-9]");
                        if (fchar == 36) {
                            width = args.getNthInt(number);
                            if (width < 0) {
                                flags |= 8;
                                width = -width;
                            }
                            ++offset;
                            continue block59;
                        }
                        width = args.nextInt();
                        if (width < 0) {
                            flags |= 8;
                            width = -width;
                        }
                        offset = mark;
                        continue block59;
                    }
                    case 46: {
                        if ((flags & 64) != 0) {
                            Sprintf.raiseArgumentError(args, "precision given twice");
                        }
                        flags |= 64;
                        Sprintf.checkOffset(args, ++offset, length, "malformed format string - %.[0-9]");
                        fchar = format[offset];
                        if (fchar == 42) {
                            Sprintf.checkOffset(args, ++offset, length, "malformed format string - %*[0-9]");
                            mark = offset;
                            number = 0;
                            while (offset < length && Sprintf.isDigit(fchar = format[offset])) {
                                number = Sprintf.extendWidth(args, number, fchar);
                                ++offset;
                            }
                            Sprintf.checkOffset(args, offset, length, "malformed format string - %*[0-9]");
                            if (fchar == 36) {
                                precision = args.getNthInt(number);
                                if (precision < 0) {
                                    flags &= -65;
                                }
                                ++offset;
                                continue block59;
                            }
                            precision = args.nextInt();
                            if (precision < 0) {
                                flags &= -65;
                            }
                            offset = mark;
                            continue block59;
                        }
                        number = 0;
                        while (offset < length && Sprintf.isDigit(fchar = format[offset])) {
                            number = Sprintf.extendWidth(args, number, fchar);
                            ++offset;
                        }
                        Sprintf.checkOffset(args, offset, length, "malformed format string - %.[0-9]");
                        precision = number;
                        continue block59;
                    }
                    case 10: {
                        --offset;
                    }
                    case 37: {
                        if (flags != 0) {
                            Sprintf.raiseArgumentError(args, "illegal format character - %");
                        }
                        buf.write(37);
                        ++offset;
                        incomplete = false;
                        continue block59;
                    }
                    case 99: {
                        if (arg == null) {
                            arg = args.next();
                        }
                        c = 0;
                        if (arg instanceof RubyString) {
                            bytes = ((RubyString)arg).getByteList();
                            if (bytes.length() == 1) {
                                c = bytes.unsafeBytes()[bytes.begin()];
                            } else {
                                Sprintf.raiseArgumentError(args, "%c requires a character");
                            }
                        } else {
                            c = args.intValue(arg);
                        }
                        if ((flags & 32) != 0 && width > 1) {
                            if ((flags & 8) != 0) {
                                buf.write(c);
                                buf.fill(32, width - 1);
                            } else {
                                buf.fill(32, width - 1);
                                buf.write(c);
                            }
                        } else {
                            buf.write(c);
                        }
                        ++offset;
                        incomplete = false;
                        continue block59;
                    }
                    case 112: 
                    case 115: {
                        if (arg == null) {
                            arg = args.next();
                        }
                        if (fchar == 112) {
                            arg = arg.callMethod(arg.getRuntime().getCurrentContext(), "inspect");
                        }
                        bytes = arg.asString().getByteList();
                        len = bytes.length();
                        if (arg.isTaint()) {
                            Buffer.access$002(buf, true);
                        }
                        if ((flags & 64) != 0 && precision < len) {
                            len = precision;
                        }
                        if ((flags & 32) != 0 && width > len) {
                            width -= len;
                            if ((flags & 8) != 0) {
                                buf.write(bytes.unsafeBytes(), bytes.begin(), len);
                                buf.fill(32, width);
                            } else {
                                buf.fill(32, width);
                                buf.write(bytes.unsafeBytes(), bytes.begin(), len);
                            }
                        } else {
                            buf.write(bytes.unsafeBytes(), bytes.begin(), len);
                        }
                        ++offset;
                        incomplete = false;
                        continue block59;
                    }
                    case 66: 
                    case 88: 
                    case 98: 
                    case 100: 
                    case 105: 
                    case 111: 
                    case 117: 
                    case 120: {
                        if (arg == null) {
                            arg = args.next();
                        }
                        if ((type = arg.getMetaClass().index) != 1 && type != 2) {
                            switch (type) {
                                case 11: {
                                    arg = RubyNumeric.dbl2num(arg.getRuntime(), ((RubyFloat)arg).getValue());
                                    break;
                                }
                                case 4: {
                                    arg = RubyNumeric.str2inum(arg.getRuntime(), (RubyString)arg, 0, true);
                                    break;
                                }
                                default: {
                                    arg = arg.respondsTo("to_int") != false ? TypeConverter.convertToType(arg, arg.getRuntime().getInteger(), MethodIndex.TO_INT, "to_int", true) : TypeConverter.convertToType(arg, arg.getRuntime().getInteger(), MethodIndex.TO_I, "to_i", true);
                                }
                            }
                            type = arg.getMetaClass().index;
                        }
                        bytes = null;
                        first = 0;
                        prefix = null;
                        signChar = 0;
                        leadChar = 0;
                        if (fchar == 105) {
                            fchar = 100;
                        }
                        if (fchar == 117 && (flags & 5) != 0) {
                            fchar = 100;
                        }
                        sign = fchar == 100 || (flags & 5) != 0;
                        switch (fchar) {
                            case 111: {
                                base = 8;
                                break;
                            }
                            case 88: 
                            case 120: {
                                base = 16;
                                break;
                            }
                            case 66: 
                            case 98: {
                                base = 2;
                                break;
                            }
                            default: {
                                base = 10;
                            }
                        }
                        if ((flags & 16) != 0) {
                            switch (fchar) {
                                case 111: {
                                    prefix = Sprintf.PREFIX_OCTAL;
                                    break;
                                }
                                case 120: {
                                    prefix = Sprintf.PREFIX_HEX_LC;
                                    break;
                                }
                                case 88: {
                                    prefix = Sprintf.PREFIX_HEX_UC;
                                    break;
                                }
                                case 98: {
                                    prefix = Sprintf.PREFIX_BINARY_LC;
                                    break;
                                }
                                case 66: {
                                    prefix = Sprintf.PREFIX_BINARY_UC;
                                }
                            }
                            if (prefix != null) {
                                width -= prefix.length;
                            }
                        }
                        if (type == 1) {
                            v0 = negative = ((RubyFixnum)arg).getLongValue() < 0L;
                            bytes = negative && fchar == 117 ? (Object)Sprintf.getUnsignedNegativeBytes((RubyFixnum)arg) : (Object)Sprintf.getFixnumBytes((RubyFixnum)arg, base, sign, fchar == 88);
                        } else {
                            v1 = negative = ((RubyBignum)arg).getValue().signum() < 0;
                            bytes = negative != false && fchar == 117 ? (Object)Sprintf.getUnsignedNegativeBytes((RubyBignum)arg) : (Object)Sprintf.getBignumBytes((RubyBignum)arg, base, sign, fchar == 88);
                        }
                        len = 0;
                        if (sign) {
                            if (negative) {
                                signChar = 45;
                                --width;
                                first = 1;
                            } else if ((flags & 4) != 0) {
                                signChar = 43;
                                --width;
                            } else if ((flags & 1) != 0) {
                                signChar = 32;
                                --width;
                            }
                        } else if (negative) {
                            if (base == 10) {
                                Sprintf.warning(IRubyWarnings.ID.NEGATIVE_NUMBER_FOR_U, args, "negative number for %u specifier");
                                leadChar = 46;
                                len += 2;
                            } else {
                                if ((flags & 66) == 0) {
                                    len += 2;
                                }
                                first = Sprintf.skipSignBits((byte[])bytes, base);
                                switch (fchar) {
                                    case 66: 
                                    case 98: {
                                        leadChar = 49;
                                        break;
                                    }
                                    case 111: {
                                        leadChar = 55;
                                        break;
                                    }
                                    case 120: {
                                        leadChar = 102;
                                        break;
                                    }
                                    case 88: {
                                        leadChar = 70;
                                    }
                                }
                                if (leadChar != 0) {
                                    ++len;
                                }
                            }
                        }
                        numlen = ((Object)bytes).length - first;
                        len += numlen;
                        if ((flags & 66) == 2) {
                            precision = width;
                            width = 0;
                        } else {
                            if (precision < len) {
                                precision = len;
                            }
                            width -= precision;
                        }
                        if ((flags & 8) == 0) {
                            buf.fill(32, width);
                            width = 0;
                        }
                        if (signChar != 0) {
                            buf.write(signChar);
                        }
                        if (prefix != null) {
                            buf.write(prefix);
                        }
                        if (len < precision) {
                            if (leadChar == 0) {
                                buf.fill(48, precision - len);
                            } else if (leadChar == 46) {
                                buf.fill(leadChar, precision - len);
                                buf.write(Sprintf.PREFIX_NEGATIVE);
                            } else {
                                buf.fill(leadChar, precision - len + 1);
                            }
                        } else if (leadChar != 0) {
                            if ((flags & 66) == 0) {
                                buf.write(Sprintf.PREFIX_NEGATIVE);
                            }
                            if (leadChar != 46) {
                                buf.write(leadChar);
                            }
                        }
                        buf.write((byte[])bytes, first, numlen);
                        if (width > 0) {
                            buf.fill(32, width);
                        }
                        ++offset;
                        incomplete = false;
                        continue block59;
                    }
                    case 69: 
                    case 71: 
                    case 101: 
                    case 102: 
                    case 103: 
                }
                if (arg == null) {
                    arg = args.next();
                }
                if (!(arg instanceof RubyFloat)) {
                    arg = RubyKernel.new_float(arg, arg);
                }
                nan = (dval = ((RubyFloat)arg).getDoubleValue()) != dval;
                inf = dval == Infinity || dval == -Infinity;
                negative = dval < 0.0;
                nDigits = 0;
                exponent = 0;
                len = 0;
                if (nan || inf) {
                    if (nan) {
                        digits = Sprintf.NAN_VALUE;
                        len = Sprintf.NAN_VALUE.length;
                    } else {
                        digits = Sprintf.INFINITY_VALUE;
                        len = Sprintf.INFINITY_VALUE.length;
                    }
                    if (negative) {
                        signChar = 45;
                        --width;
                    } else if ((flags & 4) != 0) {
                        signChar = 43;
                        --width;
                    } else if ((flags & 1) != 0) {
                        signChar = 32;
                        --width;
                    } else {
                        signChar = 0;
                    }
                    if ((width -= len) > 0 && (flags & 10) == 0) {
                        buf.fill(32, width);
                        width = 0;
                    }
                    if (signChar != 0) {
                        buf.write(signChar);
                    }
                    if (width > 0 && (flags & 8) == 0) {
                        buf.fill(48, width);
                        width = 0;
                    }
                    buf.write(digits);
                    if (width > 0) {
                        buf.fill(32, width);
                    }
                    ++offset;
                    incomplete = false;
                    continue;
                }
                str = Double.toString(dval);
                strlen = str.length();
                digits = new byte[strlen];
                nTrailingZeroes = 0;
                i = negative != false ? 1 : 0;
                decPos = 0;
                block64: while (i < strlen) {
                    ival = (byte)str.charAt(i++);
                    switch (ival) {
                        case 48: {
                            if (nDigits <= 0) ** GOTO lbl402
                            ++nTrailingZeroes;
                            ** GOTO lbl402
                        }
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            if (nTrailingZeroes > 0) {
                                while (nTrailingZeroes > 0) {
                                    digits[nDigits++] = 48;
                                    --nTrailingZeroes;
                                }
                            }
                            digits[nDigits++] = ival;
                            ** GOTO lbl402
                        }
                        case 46: {
                            break block64;
                        }
lbl402:
                        // 4 sources

                        default: {
                            continue block64;
                        }
                    }
                }
                decPos = nDigits + nTrailingZeroes;
                block66: while (i < strlen) {
                    ival = (byte)str.charAt(i++);
                    switch (ival) {
                        case 48: {
                            if (nDigits > 0) {
                                ++nTrailingZeroes;
                            } else {
                                --exponent;
                            }
                            ** GOTO lbl424
                        }
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            if (nTrailingZeroes > 0) {
                                while (nTrailingZeroes > 0) {
                                    digits[nDigits++] = 48;
                                    --nTrailingZeroes;
                                }
                            }
                            digits[nDigits++] = ival;
                            ** GOTO lbl424
                        }
                        case 69: {
                            break block66;
                        }
lbl424:
                        // 4 sources

                        default: {
                            continue block66;
                        }
                    }
                }
                if (i < strlen) {
                    expVal = 0;
                    if (str.charAt(i) == '-') {
                        expSign = -1;
                        ++i;
                    } else {
                        expSign = 1;
                    }
                    while (i < strlen) {
                        expVal = expVal * 10 + (str.charAt(i++) - 48);
                    }
                    exponent += expVal * expSign;
                }
                exponent += decPos - nDigits;
                if (nDigits == 0) {
                    digits[0] = 48;
                    nDigits = 1;
                    exponent = 0;
                }
                if (negative) {
                    signChar = 45;
                    --width;
                } else if ((flags & 4) != 0) {
                    signChar = 43;
                    --width;
                } else if ((flags & 1) != 0) {
                    signChar = 32;
                    --width;
                } else {
                    signChar = 0;
                }
                if ((flags & 64) == 0) {
                    precision = 6;
                }
                switch (fchar) {
                    case 69: 
                    case 71: {
                        expChar = 69;
                        break;
                    }
                    case 101: 
                    case 103: {
                        expChar = 101;
                        break;
                    }
                    default: {
                        expChar = 0;
                    }
                }
                switch (fchar) {
                    case 71: 
                    case 103: {
                        v2 = exponent + nDigits - 1 < -4 || exponent + nDigits > (precision == 0 ? 1 : precision) ? true : (expForm = false);
                        if (expForm) {
                            decDigits = nDigits - 1;
                            if ((precision = Math.max(0, precision - 1)) < decDigits) {
                                n = Sprintf.round(digits, nDigits, precision, precision != 0);
                                if (n > nDigits) {
                                    nDigits = n;
                                }
                                decDigits = Math.min(nDigits - 1, precision);
                            }
                            isSharp = (flags & 16) != 0;
                            ++len;
                            len = (exponent += nDigits - 1) > 99 ? (len += 5) : (len += 4);
                            if (isSharp) {
                                ++len;
                            }
                            if (precision > 0) {
                                if (!isSharp) {
                                    for (j = decDigits; j >= 1 && digits[j] == 48; --j) {
                                        --decDigits;
                                    }
                                    if (decDigits > 0) {
                                        ++len;
                                        len += decDigits;
                                    }
                                } else {
                                    len += precision;
                                }
                            }
                            if ((width -= len) > 0 && (flags & 10) == 0) {
                                buf.fill(32, width);
                                width = 0;
                            }
                            if (signChar != 0) {
                                buf.write(signChar);
                            }
                            if (width > 0 && (flags & 8) == 0) {
                                buf.fill(48, width);
                                width = 0;
                            }
                            buf.write(digits[0]);
                            v3 = dotToPrint = isSharp != false || precision > 0 && decDigits > 0;
                            if (dotToPrint) {
                                buf.write(args.getDecimalSeparator());
                            }
                            if (precision > 0 && decDigits > 0) {
                                buf.write(digits, 1, decDigits);
                                precision -= decDigits;
                            }
                            if (precision > 0 && isSharp) {
                                buf.fill(48, precision);
                            }
                            Sprintf.writeExp(buf, exponent, expChar);
                            if (width <= 0) break;
                            buf.fill(32, width);
                            break;
                        }
                        intDigits = Math.max(0, Math.min(nDigits + exponent, nDigits));
                        intZeroes = Math.max(0, exponent);
                        intLength = intDigits + intZeroes;
                        decDigits = nDigits - intDigits;
                        decZeroes = Math.max(0, -(decDigits + exponent));
                        decLength = decZeroes + decDigits;
                        if ((precision = Math.max(0, precision - intLength)) < decDigits) {
                            n = Sprintf.round(digits, nDigits, intDigits + precision - 1, precision != 0);
                            if (n > nDigits) {
                                nDigits = n;
                                intDigits = Math.max(0, Math.min(nDigits + exponent, nDigits));
                                intLength = intDigits + intZeroes;
                                decDigits = nDigits - intDigits;
                                decZeroes = Math.max(0, -(decDigits + exponent));
                                precision = Math.max(0, precision - 1);
                            }
                            decDigits = precision;
                            decLength = decZeroes + decDigits;
                        }
                        len += intLength;
                        if (decLength > 0) {
                            len += decLength + 1;
                        } else if ((flags & 16) != 0) {
                            ++len;
                            if (precision > 0) {
                                len += precision;
                            }
                        }
                        if ((width -= len) > 0 && (flags & 10) == 0) {
                            buf.fill(32, width);
                            width = 0;
                        }
                        if (signChar != 0) {
                            buf.write(signChar);
                        }
                        if (width > 0 && (flags & 8) == 0) {
                            buf.fill(48, width);
                            width = 0;
                        }
                        if (intLength > 0) {
                            if (intDigits > 0) {
                                buf.write(digits, 0, intDigits);
                            }
                            if (intZeroes > 0) {
                                buf.fill(48, intZeroes);
                            }
                        } else {
                            buf.write(48);
                        }
                        if (decLength > 0 || (flags & 16) != 0) {
                            buf.write(args.getDecimalSeparator());
                        }
                        if (decLength > 0) {
                            if (decZeroes > 0) {
                                buf.fill(48, decZeroes);
                                precision -= decZeroes;
                            }
                            if (decDigits > 0) {
                                buf.write(digits, intDigits, decDigits);
                                precision -= decDigits;
                            }
                            if ((flags & 16) != 0 && precision > 0) {
                                buf.fill(48, precision);
                            }
                        }
                        if ((flags & 16) != 0 && precision > 0) {
                            buf.fill(48, precision);
                        }
                        if (width <= 0) break;
                        buf.fill(32, width);
                        break;
                    }
                    case 102: {
                        intDigits = Math.max(0, Math.min(nDigits + exponent, nDigits));
                        intZeroes = Math.max(0, exponent);
                        intLength = intDigits + intZeroes;
                        decDigits = nDigits - intDigits;
                        decZeroes = Math.max(0, -(decDigits + exponent));
                        decLength = decZeroes + decDigits;
                        if (precision < decLength) {
                            if (precision < decZeroes) {
                                decDigits = 0;
                                decZeroes = precision;
                            } else {
                                n = Sprintf.round(digits, nDigits, intDigits + precision - decZeroes - 1, precision != 0);
                                if (n > nDigits) {
                                    nDigits = n;
                                    intDigits = Math.max(0, Math.min(nDigits + exponent, nDigits));
                                    intLength = intDigits + intZeroes;
                                    decDigits = nDigits - intDigits;
                                    decZeroes = Math.max(0, -(decDigits + exponent));
                                    decLength = decZeroes + decDigits;
                                }
                                decDigits = precision - decZeroes;
                            }
                            decLength = decZeroes + decDigits;
                        }
                        if (precision > 0) {
                            len += Math.max(1, intLength) + 1 + precision;
                        } else {
                            len += Math.max(1, intLength);
                            if ((flags & 16) != 0) {
                                ++len;
                            }
                        }
                        if ((width -= len) > 0 && (flags & 10) == 0) {
                            buf.fill(32, width);
                            width = 0;
                        }
                        if (signChar != 0) {
                            buf.write(signChar);
                        }
                        if (width > 0 && (flags & 8) == 0) {
                            buf.fill(48, width);
                            width = 0;
                        }
                        if (intLength > 0) {
                            if (intDigits > 0) {
                                buf.write(digits, 0, intDigits);
                            }
                            if (intZeroes > 0) {
                                buf.fill(48, intZeroes);
                            }
                        } else {
                            buf.write(48);
                        }
                        if (precision > 0 || (flags & 16) != 0) {
                            buf.write(args.getDecimalSeparator());
                        }
                        if (precision > 0) {
                            if (decZeroes > 0) {
                                buf.fill(48, decZeroes);
                                precision -= decZeroes;
                            }
                            if (decDigits > 0) {
                                buf.write(digits, intDigits, decDigits);
                                precision -= decDigits;
                            }
                            if (precision > 0) {
                                buf.fill(48, precision);
                            }
                        }
                        if (width <= 0) break;
                        buf.fill(32, width);
                        break;
                    }
                    case 69: 
                    case 101: {
                        decDigits = nDigits - 1;
                        if (precision < decDigits) {
                            n = Sprintf.round(digits, nDigits, precision, precision != 0);
                            if (n > nDigits) {
                                nDigits = n;
                            }
                            decDigits = Math.min(nDigits - 1, precision);
                        }
                        isSharp = (flags & 16) != 0;
                        ++len;
                        len = (exponent += nDigits - 1) > 99 ? (len += 5) : (len += 4);
                        if (precision > 0) {
                            len += 1 + precision;
                        } else if (isSharp) {
                            ++len;
                        }
                        if ((width -= len) > 0 && (flags & 10) == 0) {
                            buf.fill(32, width);
                            width = 0;
                        }
                        if (signChar != 0) {
                            buf.write(signChar);
                        }
                        if (width > 0 && (flags & 8) == 0) {
                            buf.fill(48, width);
                            width = 0;
                        }
                        buf.write(digits[0]);
                        if (precision > 0) {
                            buf.write(args.getDecimalSeparator());
                            if (decDigits > 0) {
                                buf.write(digits, 1, decDigits);
                                precision -= decDigits;
                            }
                            if (precision > 0) {
                                buf.fill(48, precision);
                            }
                        } else if ((flags & 16) != 0) {
                            buf.write(args.getDecimalSeparator());
                        }
                        Sprintf.writeExp(buf, exponent, expChar);
                        if (width <= 0) break;
                        buf.fill(32, width);
                    }
                }
                ++offset;
                incomplete = false;
            }
            if (!incomplete) continue;
            if (flags == 0) {
                buf.write(37);
                continue;
            }
            Sprintf.raiseArgumentError(args, "illegal format character - %");
        }
        if (args.numbered == 0 && args.unnumbered < args.length) {
            if (args.runtime.getDebug().isTrue()) {
                args.raiseArgumentError("too many arguments for format string");
            } else if (args.runtime.getVerbose().isTrue()) {
                args.warn(IRubyWarnings.ID.TOO_MANY_ARGUMENTS, "too many arguments for format string");
            }
        }
        return buf;
    }

    private static void writeExp(Buffer buf, int exponent, byte expChar) {
        buf.write(expChar);
        buf.write(exponent >= 0 ? 43 : 45);
        if (exponent < 0) {
            exponent = -exponent;
        }
        if (exponent > 99) {
            buf.write(exponent / 100 + 48);
            buf.write(exponent % 100 / 10 + 48);
        } else {
            buf.write(exponent / 10 + 48);
        }
        buf.write(exponent % 10 + 48);
    }

    private static final void raiseArgumentError(Args args, String message) {
        args.raiseArgumentError(message);
    }

    private static final void warning(IRubyWarnings.ID id, Args args, String message) {
        args.warning(id, message);
    }

    private static final void checkOffset(Args args, int offset, int length, String message) {
        if (offset >= length) {
            Sprintf.raiseArgumentError(args, message);
        }
    }

    private static final int extendWidth(Args args, int oldWidth, byte newChar) {
        int newWidth = oldWidth * 10 + (newChar - 48);
        if (newWidth / 10 != oldWidth) {
            Sprintf.raiseArgumentError(args, "width too big");
        }
        return newWidth;
    }

    private static final boolean isDigit(byte aChar) {
        return aChar >= 48 && aChar <= 57;
    }

    private static final boolean isPrintable(byte aChar) {
        return aChar > 32 && aChar < 127;
    }

    private static final int skipSignBits(byte[] bytes, int base) {
        int skip;
        int length = bytes.length;
        switch (base) {
            case 2: {
                for (skip = 0; skip < length && bytes[skip] == 49; ++skip) {
                }
                break;
            }
            case 8: {
                if (length > 0 && bytes[0] == 51) {
                    ++skip;
                }
                while (skip < length && bytes[skip] == 55) {
                    ++skip;
                }
                break;
            }
            case 10: {
                if (length <= 0 || bytes[0] != 45) break;
                ++skip;
                break;
            }
            case 16: {
                byte b;
                while (skip < length && ((b = bytes[skip]) == 102 || b == 70)) {
                    ++skip;
                }
                break;
            }
        }
        return skip;
    }

    private static final int round(byte[] bytes, int nDigits, int roundPos, boolean roundDown) {
        int next = roundPos + 1;
        if (next >= nDigits || bytes[next] < 53 || roundDown && bytes[next] == 53 && next == nDigits - 1) {
            return nDigits;
        }
        if (roundPos < 0) {
            System.arraycopy(bytes, 0, bytes, 1, nDigits);
            bytes[0] = 49;
            return nDigits + 1;
        }
        int n = roundPos;
        bytes[n] = (byte)(bytes[n] + 1);
        while (bytes[roundPos] > 57) {
            bytes[roundPos] = 48;
            if (--roundPos >= 0) {
                int n2 = roundPos;
                bytes[n2] = (byte)(bytes[n2] + 1);
                continue;
            }
            System.arraycopy(bytes, 0, bytes, 1, nDigits);
            bytes[0] = 49;
            return nDigits + 1;
        }
        return nDigits;
    }

    private static final byte[] getFixnumBytes(RubyFixnum arg, int base, boolean sign, boolean upper) {
        long val = arg.getLongValue();
        if (val >= Integer.MIN_VALUE && val <= Integer.MAX_VALUE) {
            if (sign) {
                return Convert.intToByteArray((int)val, base, upper);
            }
            switch (base) {
                case 2: {
                    return Convert.intToBinaryBytes((int)val);
                }
                case 8: {
                    return Convert.intToOctalBytes((int)val);
                }
                default: {
                    return Convert.intToCharBytes((int)val);
                }
                case 16: 
            }
            return Convert.intToHexBytes((int)val, upper);
        }
        if (sign) {
            return Convert.longToByteArray(val, base, upper);
        }
        switch (base) {
            case 2: {
                return Convert.longToBinaryBytes(val);
            }
            case 8: {
                return Convert.longToOctalBytes(val);
            }
            default: {
                return Convert.longToCharBytes(val);
            }
            case 16: 
        }
        return Convert.longToHexBytes(val, upper);
    }

    private static final byte[] getBignumBytes(RubyBignum arg, int base, boolean sign, boolean upper) {
        BigInteger val = arg.getValue();
        if (sign || base == 10 || val.signum() >= 0) {
            return Sprintf.stringToBytes(val.toString(base), upper);
        }
        byte[] bytes = val.toByteArray();
        switch (base) {
            case 2: {
                return Convert.twosComplementToBinaryBytes(bytes);
            }
            case 8: {
                return Convert.twosComplementToOctalBytes(bytes);
            }
            case 16: {
                return Convert.twosComplementToHexBytes(bytes, upper);
            }
        }
        return Sprintf.stringToBytes(val.toString(base), upper);
    }

    private static final byte[] getUnsignedNegativeBytes(RubyInteger arg) {
        BigInteger bigval;
        if (arg instanceof RubyFixnum) {
            long longval = ((RubyFixnum)arg).getLongValue();
            if (longval >= -4294967296L) {
                return Convert.longToCharBytes(0x100000000L + longval);
            }
            bigval = BigInteger.valueOf(longval);
        } else {
            bigval = ((RubyBignum)arg).getValue();
        }
        int shift = 0;
        BigInteger minus = BIG_MINUS_64;
        while (bigval.compareTo(minus) < 0) {
            minus = minus.shiftLeft(32);
            ++shift;
        }
        BigInteger nPower32 = shift > 0 ? BIG_64.shiftLeft(32 * shift) : BIG_64;
        return Sprintf.stringToBytes(nPower32.add(bigval).toString(), false);
    }

    private static final byte[] stringToBytes(CharSequence s, boolean upper) {
        int len = s.length();
        byte[] bytes = new byte[len];
        if (upper) {
            int i = len;
            while (--i >= 0) {
                byte b = (byte)(s.charAt(i) & 0xFF);
                if (b >= 97 && b <= 122) {
                    bytes[i] = (byte)(b & 0xFFFFFFDF);
                    continue;
                }
                bytes[i] = b;
            }
        } else {
            int i = len;
            while (--i >= 0) {
                bytes[i] = (byte)(s.charAt(i) & 0xFF);
            }
        }
        return bytes;
    }

    private static class Buffer {
        byte[] buf;
        int size;
        private boolean tainted = false;

        Buffer() {
            this.buf = new byte[32];
        }

        Buffer(int initialSize) {
            this.buf = new byte[initialSize];
        }

        final void write(int b) {
            int newSize = this.size + 1;
            if (newSize > this.buf.length) {
                byte[] newBuf = new byte[Math.max(this.buf.length << 1, newSize)];
                System.arraycopy(this.buf, 0, newBuf, 0, this.size);
                this.buf = newBuf;
            }
            this.buf[this.size] = (byte)(b & 0xFF);
            this.size = newSize;
        }

        final void write(byte[] b, int off, int len) {
            if (len <= 0 || off < 0) {
                return;
            }
            int newSize = this.size + len;
            if (newSize > this.buf.length) {
                byte[] newBuf = new byte[Math.max(this.buf.length << 1, newSize)];
                System.arraycopy(this.buf, 0, newBuf, 0, this.size);
                this.buf = newBuf;
            }
            System.arraycopy(b, off, this.buf, this.size, len);
            this.size = newSize;
        }

        final void write(byte[] b) {
            this.write(b, 0, b.length);
        }

        final void fill(int b, int len) {
            if (len <= 0) {
                return;
            }
            int newSize = this.size + len;
            if (newSize > this.buf.length) {
                byte[] newBuf = new byte[Math.max(this.buf.length << 1, newSize)];
                System.arraycopy(this.buf, 0, newBuf, 0, this.size);
                this.buf = newBuf;
            }
            byte fillval = (byte)(b & 0xFF);
            while (--len >= 0) {
                this.buf[this.size + len] = fillval;
            }
            this.size = newSize;
        }

        final void set(int b, int pos) {
            if (pos < 0) {
                pos += this.size;
            }
            if (pos >= 0 && pos < this.size) {
                this.buf[pos] = (byte)(b & 0xFF);
            }
        }

        final void set(int b) {
            if (this.size > 0) {
                this.buf[this.size - 1] = (byte)(b & 0xFF);
            }
        }

        final ByteList toByteList() {
            return new ByteList(this.buf, 0, this.size);
        }

        public final String toString() {
            return new String(this.buf, 0, this.size);
        }

        static /* synthetic */ boolean access$002(Buffer x0, boolean x1) {
            x0.tainted = x1;
            return x0.tainted;
        }
    }

    private static class Args {
        Ruby runtime;
        Locale locale;
        IRubyObject rubyObject;
        List rubyArray;
        int length;
        int unnumbered;
        int numbered;

        Args(Locale locale, IRubyObject rubyObject) {
            if (rubyObject == null) {
                throw new IllegalArgumentException("null IRubyObject passed to sprintf");
            }
            this.locale = locale == null ? Locale.getDefault() : locale;
            this.rubyObject = rubyObject;
            if (rubyObject instanceof RubyArray) {
                this.rubyArray = ((RubyArray)rubyObject).getList();
                this.length = this.rubyArray.size();
            } else {
                this.length = 1;
            }
            this.runtime = rubyObject.getRuntime();
        }

        Args(IRubyObject rubyObject) {
            this(Locale.getDefault(), rubyObject);
        }

        Args(Ruby runtime, long value) {
            this(RubyFixnum.newFixnum(runtime, value));
        }

        final void raiseArgumentError(String message) {
            throw this.runtime.newArgumentError(message);
        }

        final void warn(IRubyWarnings.ID id, String message) {
            this.runtime.getWarnings().warn(id, message, new Object[0]);
        }

        final void warning(IRubyWarnings.ID id, String message) {
            this.runtime.getWarnings().warning(id, message, new Object[0]);
        }

        final IRubyObject next() {
            if (this.numbered > 0) {
                this.raiseArgumentError("unnumbered" + (this.unnumbered + 1) + "mixed with numbered");
            }
            if (this.unnumbered >= this.length) {
                this.raiseArgumentError("too few arguments");
            }
            IRubyObject object = this.rubyArray == null ? this.rubyObject : (IRubyObject)this.rubyArray.get(this.unnumbered);
            ++this.unnumbered;
            return object;
        }

        final IRubyObject get(int index) {
            if (this.unnumbered > 0) {
                this.raiseArgumentError("numbered(" + this.numbered + ") after unnumbered(" + this.unnumbered + ")");
            }
            if (index < 0) {
                this.raiseArgumentError("invalid index - " + (index + 1) + '$');
            }
            if (index >= this.length) {
                this.raiseArgumentError("too few arguments");
            }
            this.numbered = index + 1;
            return this.rubyArray == null ? this.rubyObject : (IRubyObject)this.rubyArray.get(index);
        }

        final IRubyObject getNth(int formatIndex) {
            return this.get(formatIndex - 1);
        }

        final int nextInt() {
            return this.intValue(this.next());
        }

        final int getInt(int index) {
            return this.intValue(this.get(index));
        }

        final int getNthInt(int formatIndex) {
            return this.intValue(this.get(formatIndex - 1));
        }

        final int intValue(IRubyObject obj) {
            if (obj instanceof RubyNumeric) {
                return (int)((RubyNumeric)obj).getLongValue();
            }
            obj = TypeConverter.convertToType(obj, obj.getRuntime().getFixnum(), MethodIndex.TO_INT, "to_int", true);
            return (int)((RubyFixnum)obj).getLongValue();
        }

        final byte getDecimalSeparator() {
            return (byte)new DecimalFormatSymbols(this.locale).getDecimalSeparator();
        }
    }
}

