/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.integration.spring;

import org.apache.mina.common.IoAcceptor;
import org.apache.mina.integration.spring.Binding;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class IoAcceptorFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    private Binding[] bindings = new Binding[0];
    private IoAcceptor target;

    public void setTarget(IoAcceptor target) {
        this.target = target;
    }

    public void setBindings(Binding[] bindings) {
        Assert.notNull((Object)bindings, (String)"Property 'bindings' may not be null");
        this.bindings = bindings;
    }

    public Object getObject() throws Exception {
        return this.target;
    }

    public Class getObjectType() {
        return IoAcceptor.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.target, (String)"Property 'target' may not be null");
        for (int i = 0; i < this.bindings.length; ++i) {
            Binding b = this.bindings[i];
            if (b.getServiceConfig() != null) {
                this.target.bind(b.getAddress(), b.getHandler(), b.getServiceConfig());
                continue;
            }
            this.target.bind(b.getAddress(), b.getHandler());
        }
    }

    public void destroy() throws Exception {
        for (int i = 0; i < this.bindings.length; ++i) {
            Binding b = this.bindings[i];
            try {
                this.target.unbind(b.getAddress());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

