/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.integration.spring;

import java.beans.PropertyEditorSupport;
import java.net.SocketAddress;
import org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.springframework.util.Assert;

public class VmPipeAddressEditor
extends PropertyEditorSupport {
    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(this.parseSocketAddress(text));
    }

    private SocketAddress parseSocketAddress(String s) {
        Assert.notNull((Object)s, (String)"null SocketAddress string");
        s = s.trim();
        if (s.startsWith(":")) {
            s = s.substring(1);
        }
        try {
            return new VmPipeAddress(Integer.parseInt(s.trim()));
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Illegal vm pipe address: " + s);
        }
    }
}

