/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.osgi;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.osgi.Activator;
import org.apache.camel.spi.ComponentResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OsgiComponentResolver
implements ComponentResolver {
    private static final transient Log LOG = LogFactory.getLog(OsgiComponentResolver.class);

    protected Class getComponent(String name) throws Exception {
        return Activator.getComponent(name);
    }

    public Component resolveComponent(String name, CamelContext context) throws Exception {
        Object bean = null;
        try {
            bean = context.getRegistry().lookup(name);
            if (bean != null && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found component: " + name + " in registry: " + bean));
            }
        }
        catch (Exception e) {
            LOG.debug((Object)("Ignored error looking up bean: " + name + ". Error: " + e));
        }
        if (bean != null && bean instanceof Component) {
            return (Component)bean;
        }
        Class type = null;
        try {
            type = this.getComponent(name);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Invalid URI, no Component registered for scheme : " + name, e);
        }
        if (type == null) {
            return null;
        }
        if (Component.class.isAssignableFrom(type)) {
            return (Component)context.getInjector().newInstance(type);
        }
        throw new IllegalArgumentException("Type is not a Component implementation. Found: " + type.getName());
    }
}

