/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.jms.Destination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.console.command.AbstractAmqCommand;
import org.apache.activemq.console.util.AmqMessagesUtil;

public class AmqBrowseCommand
extends AbstractAmqCommand {
    public static final String QUEUE_PREFIX = "queue:";
    public static final String TOPIC_PREFIX = "topic:";
    public static final String VIEW_GROUP_HEADER = "header:";
    public static final String VIEW_GROUP_CUSTOM = "custom:";
    public static final String VIEW_GROUP_BODY = "body:";
    protected String[] helpFile = new String[]{"Task Usage: Main browse --amqurl <broker url> [browse-options] <destinations>", "Description: Display selected destination's messages.", "", "Browse Options:", "    --amqurl <url>                Set the broker URL to connect to.", "    --msgsel <msgsel1,msglsel2>   Add to the search list messages matched by the query similar to", "                                  the messages selector format.", "    -V<header|custom|body>        Predefined view that allows you to view the message header, custom", "                                  message header, or the message body.", "    --view <attr1>,<attr2>,...    Select the specific attribute of the message to view.", "    --version                     Display the version information.", "    -h,-?,--help                  Display the browse broker help information.", "", "Examples:", "    Main browse --amqurl tcp://localhost:61616 FOO.BAR", "        - Print the message header, custom message header, and message body of all messages in the", "          queue FOO.BAR", "", "    Main browse --amqurl tcp://localhost:61616 -Vheader,body queue:FOO.BAR", "        - Print only the message header and message body of all messages in the queue FOO.BAR", "", "    Main browse --amqurl tcp://localhost:61616 -Vheader --view custom:MyField queue:FOO.BAR", "        - Print the message header and the custom field 'MyField' of all messages in the queue FOO.BAR", "", "    Main browse --amqurl tcp://localhost:61616 --msgsel JMSMessageID='*:10',JMSPriority>5 FOO.BAR", "        - Print all the message fields that has a JMSMessageID in the header field that matches the", "          wildcard *:10, and has a JMSPriority field > 5 in the queue FOO.BAR", "        * To use wildcard queries, the field must be a string and the query enclosed in ''", ""};
    private final List<String> queryAddObjects = new ArrayList<String>(10);
    private final List<String> querySubObjects = new ArrayList<String>(10);
    private final Set<String> groupViews = new HashSet<String>(10);
    private final Set queryViews = new HashSet(10);

    protected void runTask(List tokens) throws Exception {
        try {
            if (tokens.isEmpty()) {
                this.context.printException(new IllegalArgumentException("No JMS destination specified."));
                return;
            }
            if (this.getBrokerUrl() == null) {
                this.context.printException(new IllegalStateException("No broker url specified. Use the --amqurl option to specify a broker url."));
                return;
            }
            for (String destName : tokens) {
                Object dest = destName.startsWith(QUEUE_PREFIX) ? new ActiveMQQueue(destName.substring(QUEUE_PREFIX.length())) : (destName.startsWith(TOPIC_PREFIX) ? new ActiveMQTopic(destName.substring(TOPIC_PREFIX.length())) : new ActiveMQQueue(destName));
                List addMsgs = AmqMessagesUtil.getMessages(this.getBrokerUrl(), (Destination)dest, this.queryAddObjects);
                if (this.querySubObjects.size() > 0) {
                    List subMsgs = AmqMessagesUtil.getMessages(this.getBrokerUrl(), (Destination)dest, this.querySubObjects);
                    addMsgs.removeAll(subMsgs);
                }
                this.context.printMessage(AmqMessagesUtil.filterMessagesView(addMsgs, this.groupViews, this.queryViews));
            }
        }
        catch (Exception e) {
            this.context.printException(new RuntimeException("Failed to execute browse task. Reason: " + e));
            throw new Exception(e);
        }
    }

    protected void handleOption(String token, List tokens) throws Exception {
        if (token.startsWith("--msgsel")) {
            if (tokens.isEmpty() || ((String)tokens.get(0)).startsWith("-")) {
                this.context.printException(new IllegalArgumentException("Message selector not specified"));
                return;
            }
            StringTokenizer queryTokens = new StringTokenizer((String)tokens.remove(0), ",");
            while (queryTokens.hasMoreTokens()) {
                this.queryAddObjects.add(queryTokens.nextToken());
            }
        } else if (token.startsWith("--xmsgsel")) {
            if (tokens.isEmpty() || ((String)tokens.get(0)).startsWith("-")) {
                this.context.printException(new IllegalArgumentException("Message selector not specified"));
                return;
            }
            StringTokenizer queryTokens = new StringTokenizer((String)tokens.remove(0), ",");
            while (queryTokens.hasMoreTokens()) {
                this.querySubObjects.add(queryTokens.nextToken());
            }
        } else if (token.startsWith("--view")) {
            if (tokens.isEmpty() || ((String)tokens.get(0)).startsWith("-")) {
                this.context.printException(new IllegalArgumentException("Attributes to view not specified"));
                return;
            }
            StringTokenizer viewTokens = new StringTokenizer((String)tokens.remove(0), ",");
            while (viewTokens.hasMoreTokens()) {
                String viewToken = viewTokens.nextToken();
                if (viewToken.equals(VIEW_GROUP_HEADER)) {
                    this.queryViews.add("JMS_HEADER_FIELD:" + viewToken.substring(VIEW_GROUP_HEADER.length()));
                    continue;
                }
                if (viewToken.equals(VIEW_GROUP_CUSTOM)) {
                    this.queryViews.add("JMS_CUSTOM_FIELD:" + viewToken.substring(VIEW_GROUP_CUSTOM.length()));
                    continue;
                }
                if (viewToken.equals(VIEW_GROUP_BODY)) {
                    this.queryViews.add("JMS_BODY_FIELD:" + viewToken.substring(VIEW_GROUP_BODY.length()));
                    continue;
                }
                this.queryViews.add("JMS_HEADER_FIELD:" + viewToken);
                this.queryViews.add("JMS_CUSTOM_FIELD:" + viewToken);
                this.queryViews.add("JMS_BODY_FIELD:" + viewToken);
            }
        } else if (token.startsWith("-V")) {
            String viewGroup = token.substring(2);
            if (viewGroup.equals("header")) {
                this.groupViews.add("JMS_HEADER_FIELD:");
            } else if (viewGroup.equals("custom")) {
                this.groupViews.add("JMS_CUSTOM_FIELD:");
            } else if (viewGroup.equals("body")) {
                this.groupViews.add("JMS_BODY_FIELD:");
            } else {
                this.context.printInfo("Unknown group view: " + viewGroup + ". Ignoring group view option.");
            }
        } else {
            super.handleOption(token, tokens);
        }
    }

    protected void printHelp() {
        this.context.printHelp(this.helpFile);
    }
}

