/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command;

import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.activemq.console.CommandContext;
import org.apache.activemq.console.command.AbstractCommand;
import org.apache.activemq.console.command.AmqBrowseCommand;
import org.apache.activemq.console.command.BstatCommand;
import org.apache.activemq.console.command.Command;
import org.apache.activemq.console.command.CreateCommand;
import org.apache.activemq.console.command.ListCommand;
import org.apache.activemq.console.command.PurgeCommand;
import org.apache.activemq.console.command.QueryCommand;
import org.apache.activemq.console.command.ShutdownCommand;
import org.apache.activemq.console.command.StartCommand;
import org.apache.activemq.console.formatter.CommandShellOutputFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShellCommand
extends AbstractCommand {
    private boolean interactive;
    private String[] helpFile;

    public ShellCommand() {
        this(false);
    }

    public ShellCommand(boolean interactive) {
        this.interactive = interactive;
        this.helpFile = new String[]{interactive ? "Usage: [task] [task-options] [task data]" : "Usage: Main [--extdir <dir>] [task] [task-options] [task data]", "", "Tasks (default task is start):", "    start           - Creates and starts a broker using a configuration file, or a broker URI.", "    create          - Creates a runnable broker instance in the specified path", "    stop            - Stops a running broker specified by the broker name.", "    list            - Lists all available brokers in the specified JMX context.", "    query           - Display selected broker component's attributes and statistics.", "    browse          - Display selected messages in a specified destination.", "    journal-audit   - Allows you to view records stored in the persistent journal.", "", "Task Options (Options specific to each task):", "    --extdir <dir>  - Add the jar files in the directory to the classpath.", "    --version       - Display the version information.", "    -h,-?,--help    - Display this help information. To display task specific help, use " + (interactive ? "" : "Main ") + "[task] -h,-?,--help", "", "Task Data:", "    - Information needed by each specific task.", ""};
    }

    public static int main(String[] args, InputStream in, PrintStream out) {
        CommandContext context = new CommandContext();
        context.setFormatter(new CommandShellOutputFormatter(out));
        ArrayList<String> tokens = new ArrayList<String>(Arrays.asList(args));
        ShellCommand main = new ShellCommand();
        try {
            main.setCommandContext(context);
            main.execute(tokens);
            return 0;
        }
        catch (Exception e) {
            context.printException(e);
            return -1;
        }
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    @Override
    protected void runTask(List<String> tokens) throws Exception {
        if (tokens.size() > 0) {
            Command command = null;
            String taskToken = tokens.remove(0);
            if (taskToken.equals("start")) {
                command = new StartCommand();
            } else if (taskToken.equals("create")) {
                new CreateCommand().execute(tokens);
            } else if (taskToken.equals("stop")) {
                command = new ShutdownCommand();
            } else if (taskToken.equals("list")) {
                command = new ListCommand();
            } else if (taskToken.equals("query")) {
                command = new QueryCommand();
            } else if (taskToken.equals("bstat")) {
                command = new BstatCommand();
            } else if (taskToken.equals("browse")) {
                command = new AmqBrowseCommand();
            } else if (taskToken.equals("purge")) {
                command = new PurgeCommand();
            } else if (taskToken.equals("journal-audit")) {
                command = this.createJournalAuditCommand();
                if (command == null) {
                    this.context.print("Could not load the journal-audit command.  Classpath is not setup correctly.  Make sure the activemq-fuse module is in the classpath.");
                }
            } else if (taskToken.equals("help")) {
                this.printHelp();
            } else {
                this.printHelp();
            }
            if (command != null) {
                command.setCommandContext(this.context);
                command.execute(tokens);
            }
        } else {
            this.printHelp();
        }
    }

    private Command createJournalAuditCommand() {
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass("com.iona.fuse.mb.store.amq.AMQJournalToolCommand");
            return (Command)clazz.newInstance();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    protected void printHelp() {
        this.context.printHelp(this.helpFile);
    }
}

