/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployer.descriptor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.servicemix.jbi.deployer.descriptor.ClassPath;
import org.apache.servicemix.jbi.deployer.descriptor.ComponentDesc;
import org.apache.servicemix.jbi.deployer.descriptor.Connection;
import org.apache.servicemix.jbi.deployer.descriptor.Connections;
import org.apache.servicemix.jbi.deployer.descriptor.Consumer;
import org.apache.servicemix.jbi.deployer.descriptor.Consumes;
import org.apache.servicemix.jbi.deployer.descriptor.Descriptor;
import org.apache.servicemix.jbi.deployer.descriptor.Identification;
import org.apache.servicemix.jbi.deployer.descriptor.InstallationDescriptorExtension;
import org.apache.servicemix.jbi.deployer.descriptor.Provider;
import org.apache.servicemix.jbi.deployer.descriptor.Provides;
import org.apache.servicemix.jbi.deployer.descriptor.ServiceAssemblyDesc;
import org.apache.servicemix.jbi.deployer.descriptor.ServiceUnitDesc;
import org.apache.servicemix.jbi.deployer.descriptor.Services;
import org.apache.servicemix.jbi.deployer.descriptor.SharedLibraryDesc;
import org.apache.servicemix.jbi.deployer.descriptor.SharedLibraryList;
import org.apache.servicemix.jbi.deployer.descriptor.Target;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptorFactory {
    private static final String XSD_SCHEMA_LANGUAGE = "http://www.w3.org/2001/XMLSchema";
    public static final String DESCRIPTOR_FILE = "META-INF/jbi.xml";

    public static Descriptor buildDescriptor(File descriptorFile) {
        if (descriptorFile.isDirectory()) {
            descriptorFile = new File(descriptorFile, DESCRIPTOR_FILE);
        }
        if (descriptorFile.isFile()) {
            try {
                return DescriptorFactory.buildDescriptor(descriptorFile.toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("There is a bug here...", e);
            }
        }
        return null;
    }

    public static Descriptor buildDescriptor(URL url) {
        try {
            return DescriptorFactory.buildDescriptor(url.openStream());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Descriptor buildDescriptor(InputStream stream) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DescriptorFactory.copyInputStream(stream, baos);
            return DescriptorFactory.buildDescriptor(baos.toByteArray());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Descriptor buildDescriptor(byte[] bytes) {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance(XSD_SCHEMA_LANGUAGE);
            Schema schema = schemaFactory.newSchema(DescriptorFactory.class.getResource("jbi-descriptor.xsd"));
            Validator validator = schema.newValidator();
            validator.setErrorHandler(new ErrorHandler(){

                public void warning(SAXParseException exception) throws SAXException {
                }

                public void error(SAXParseException exception) throws SAXException {
                }

                public void fatalError(SAXParseException exception) throws SAXException {
                    throw exception;
                }
            });
            validator.validate(new StreamSource(new ByteArrayInputStream(bytes)));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            Document doc = docBuilder.parse(new ByteArrayInputStream(bytes));
            Element jbi = doc.getDocumentElement();
            Descriptor desc = new Descriptor();
            desc.setVersion(Double.parseDouble(DescriptorFactory.getAttribute(jbi, "version")));
            Element child = DescriptorFactory.getFirstChildElement(jbi);
            if ("component".equals(child.getLocalName())) {
                ComponentDesc component = new ComponentDesc();
                component.setType(child.getAttribute("type"));
                component.setComponentClassLoaderDelegation(DescriptorFactory.getAttribute(child, "component-class-loader-delegation"));
                component.setBootstrapClassLoaderDelegation(DescriptorFactory.getAttribute(child, "bootstrap-class-loader-delegation"));
                ArrayList<SharedLibraryList> sls = new ArrayList<SharedLibraryList>();
                DocumentFragment ext = null;
                Element e = DescriptorFactory.getFirstChildElement(child);
                while (e != null) {
                    Element e2;
                    ArrayList<String> l;
                    if ("identification".equals(e.getLocalName())) {
                        component.setIdentification(DescriptorFactory.readIdentification(e));
                    } else if ("component-class-name".equals(e.getLocalName())) {
                        component.setComponentClassName(DescriptorFactory.getText(e));
                        component.setDescription(DescriptorFactory.getAttribute(e, "description"));
                    } else if ("component-class-path".equals(e.getLocalName())) {
                        ClassPath componentClassPath = new ClassPath();
                        l = new ArrayList<String>();
                        e2 = DescriptorFactory.getFirstChildElement(e);
                        while (e2 != null) {
                            if ("path-element".equals(e2.getLocalName())) {
                                l.add(DescriptorFactory.getText(e2));
                            }
                            e2 = DescriptorFactory.getNextSiblingElement(e2);
                        }
                        componentClassPath.setPathList(l);
                        component.setComponentClassPath(componentClassPath);
                    } else if ("bootstrap-class-name".equals(e.getLocalName())) {
                        component.setBootstrapClassName(DescriptorFactory.getText(e));
                    } else if ("bootstrap-class-path".equals(e.getLocalName())) {
                        ClassPath bootstrapClassPath = new ClassPath();
                        l = new ArrayList();
                        e2 = DescriptorFactory.getFirstChildElement(e);
                        while (e2 != null) {
                            if ("path-element".equals(e2.getLocalName())) {
                                l.add(DescriptorFactory.getText(e2));
                            }
                            e2 = DescriptorFactory.getNextSiblingElement(e2);
                        }
                        bootstrapClassPath.setPathList(l);
                        component.setBootstrapClassPath(bootstrapClassPath);
                    } else if ("shared-library".equals(e.getLocalName())) {
                        SharedLibraryList sl = new SharedLibraryList();
                        sl.setName(DescriptorFactory.getText(e));
                        sl.setVersion(DescriptorFactory.getAttribute(e, "version"));
                        sls.add(sl);
                    } else {
                        if (ext == null) {
                            ext = doc.createDocumentFragment();
                        }
                        ext.appendChild(e);
                    }
                    e = DescriptorFactory.getNextSiblingElement(e);
                }
                component.setSharedLibraries(sls.toArray(new SharedLibraryList[sls.size()]));
                if (ext != null) {
                    InstallationDescriptorExtension descriptorExtension = new InstallationDescriptorExtension();
                    descriptorExtension.setDescriptorExtension(ext);
                    component.setDescriptorExtension(descriptorExtension);
                }
                desc.setComponent(component);
            } else if ("shared-library".equals(child.getLocalName())) {
                SharedLibraryDesc sharedLibrary = new SharedLibraryDesc();
                sharedLibrary.setClassLoaderDelegation(DescriptorFactory.getAttribute(child, "class-loader-delegation"));
                sharedLibrary.setVersion(DescriptorFactory.getAttribute(child, "version"));
                Element e = DescriptorFactory.getFirstChildElement(child);
                while (e != null) {
                    if ("identification".equals(e.getLocalName())) {
                        sharedLibrary.setIdentification(DescriptorFactory.readIdentification(e));
                    } else if ("shared-library-class-path".equals(e.getLocalName())) {
                        ClassPath sharedLibraryClassPath = new ClassPath();
                        ArrayList<String> l = new ArrayList<String>();
                        Element e2 = DescriptorFactory.getFirstChildElement(e);
                        while (e2 != null) {
                            if ("path-element".equals(e2.getLocalName())) {
                                l.add(DescriptorFactory.getText(e2));
                            }
                            e2 = DescriptorFactory.getNextSiblingElement(e2);
                        }
                        sharedLibraryClassPath.setPathList(l);
                        sharedLibrary.setSharedLibraryClassPath(sharedLibraryClassPath);
                    }
                    e = DescriptorFactory.getNextSiblingElement(e);
                }
                desc.setSharedLibrary(sharedLibrary);
            } else if ("service-assembly".equals(child.getLocalName())) {
                ServiceAssemblyDesc serviceAssembly = new ServiceAssemblyDesc();
                ArrayList<ServiceUnitDesc> sus = new ArrayList<ServiceUnitDesc>();
                Element e = DescriptorFactory.getFirstChildElement(child);
                while (e != null) {
                    if ("identification".equals(e.getLocalName())) {
                        serviceAssembly.setIdentification(DescriptorFactory.readIdentification(e));
                    } else if ("service-unit".equals(e.getLocalName())) {
                        ServiceUnitDesc su = new ServiceUnitDesc();
                        Element e2 = DescriptorFactory.getFirstChildElement(e);
                        while (e2 != null) {
                            if ("identification".equals(e2.getLocalName())) {
                                su.setIdentification(DescriptorFactory.readIdentification(e2));
                            } else if ("target".equals(e2.getLocalName())) {
                                Target target = new Target();
                                Element e3 = DescriptorFactory.getFirstChildElement(e2);
                                while (e3 != null) {
                                    if ("artifacts-zip".equals(e3.getLocalName())) {
                                        target.setArtifactsZip(DescriptorFactory.getText(e3));
                                    } else if ("component-name".equals(e3.getLocalName())) {
                                        target.setComponentName(DescriptorFactory.getText(e3));
                                    }
                                    e3 = DescriptorFactory.getNextSiblingElement(e3);
                                }
                                su.setTarget(target);
                            }
                            e2 = DescriptorFactory.getNextSiblingElement(e2);
                        }
                        sus.add(su);
                    } else if ("connections".equals(e.getLocalName())) {
                        Connections connections = new Connections();
                        ArrayList<Connection> cns = new ArrayList<Connection>();
                        Element e2 = DescriptorFactory.getFirstChildElement(e);
                        while (e2 != null) {
                            if ("connection".equals(e2.getLocalName())) {
                                Connection cn = new Connection();
                                Element e3 = DescriptorFactory.getFirstChildElement(e2);
                                while (e3 != null) {
                                    if ("consumer".equals(e3.getLocalName())) {
                                        Consumer consumer = new Consumer();
                                        consumer.setInterfaceName(DescriptorFactory.readAttributeQName(e3, "interface-name"));
                                        consumer.setServiceName(DescriptorFactory.readAttributeQName(e3, "service-name"));
                                        consumer.setEndpointName(DescriptorFactory.getAttribute(e3, "endpoint-name"));
                                        cn.setConsumer(consumer);
                                    } else if ("provider".equals(e3.getLocalName())) {
                                        Provider provider = new Provider();
                                        provider.setServiceName(DescriptorFactory.readAttributeQName(e3, "service-name"));
                                        provider.setEndpointName(DescriptorFactory.getAttribute(e3, "endpoint-name"));
                                        cn.setProvider(provider);
                                    }
                                    e3 = DescriptorFactory.getNextSiblingElement(e3);
                                }
                                cns.add(cn);
                            }
                            e2 = DescriptorFactory.getNextSiblingElement(e2);
                        }
                        connections.setConnections(cns.toArray(new Connection[cns.size()]));
                        serviceAssembly.setConnections(connections);
                    }
                    e = DescriptorFactory.getNextSiblingElement(e);
                }
                serviceAssembly.setServiceUnits(sus.toArray(new ServiceUnitDesc[sus.size()]));
                desc.setServiceAssembly(serviceAssembly);
            } else if ("services".equals(child.getLocalName())) {
                Services services = new Services();
                services.setBindingComponent(Boolean.valueOf(DescriptorFactory.getAttribute(child, "binding-component")));
                ArrayList<Provides> provides = new ArrayList<Provides>();
                ArrayList<Consumes> consumes = new ArrayList<Consumes>();
                Element e = DescriptorFactory.getFirstChildElement(child);
                while (e != null) {
                    if ("provides".equals(e.getLocalName())) {
                        Provides p = new Provides();
                        p.setInterfaceName(DescriptorFactory.readAttributeQName(e, "interface-name"));
                        p.setServiceName(DescriptorFactory.readAttributeQName(e, "service-name"));
                        p.setEndpointName(DescriptorFactory.getAttribute(e, "endpoint-name"));
                        provides.add(p);
                    } else if ("consumes".equals(e.getLocalName())) {
                        Consumes c = new Consumes();
                        c.setInterfaceName(DescriptorFactory.readAttributeQName(e, "interface-name"));
                        c.setServiceName(DescriptorFactory.readAttributeQName(e, "service-name"));
                        c.setEndpointName(DescriptorFactory.getAttribute(e, "endpoint-name"));
                        c.setLinkType(DescriptorFactory.getAttribute(e, "link-type"));
                        consumes.add(c);
                    }
                    e = DescriptorFactory.getNextSiblingElement(e);
                }
                services.setProvides(provides.toArray(new Provides[provides.size()]));
                services.setConsumes(consumes.toArray(new Consumes[consumes.size()]));
                desc.setServices(services);
            }
            DescriptorFactory.checkDescriptor(desc);
            return desc;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getAttribute(Element e, String name) {
        if (e.hasAttribute(name)) {
            return e.getAttribute(name);
        }
        return null;
    }

    private static QName readAttributeQName(Element e, String name) {
        String attr = DescriptorFactory.getAttribute(e, name);
        if (attr != null) {
            return DescriptorFactory.createQName(e, attr);
        }
        return null;
    }

    private static String getText(Element e) {
        return DescriptorFactory.getElementText(e).trim();
    }

    private static Identification readIdentification(Element e) {
        Identification ident = new Identification();
        Element e2 = DescriptorFactory.getFirstChildElement(e);
        while (e2 != null) {
            if ("name".equals(e2.getLocalName())) {
                ident.setName(DescriptorFactory.getElementText(e2));
            } else if ("description".equals(e2.getLocalName())) {
                ident.setDescription(DescriptorFactory.getElementText(e2));
            }
            e2 = DescriptorFactory.getNextSiblingElement(e2);
        }
        return ident;
    }

    public static void checkDescriptor(Descriptor descriptor) {
        ArrayList<String> violations = new ArrayList<String>();
        if (descriptor.getVersion() != 1.0) {
            violations.add("JBI descriptor version should be set to '1.0' but is " + descriptor.getVersion());
        }
        if (descriptor.getComponent() != null) {
            DescriptorFactory.checkComponent(violations, descriptor.getComponent());
        } else if (descriptor.getServiceAssembly() != null) {
            DescriptorFactory.checkServiceAssembly(violations, descriptor.getServiceAssembly());
        } else if (descriptor.getServices() != null) {
            DescriptorFactory.checkServiceUnit(violations, descriptor.getServices());
        } else if (descriptor.getSharedLibrary() != null) {
            DescriptorFactory.checkSharedLibrary(violations, descriptor.getSharedLibrary());
        } else {
            violations.add("The jbi descriptor does not contain any informations");
        }
        if (violations.size() > 0) {
            throw new RuntimeException("The JBI descriptor is not valid, please correct these violations " + ((Object)violations).toString());
        }
    }

    private static void checkComponent(List<String> violations, ComponentDesc component) {
        if (component.getIdentification() == null) {
            violations.add("The component has not identification");
        } else if (DescriptorFactory.isBlank(component.getIdentification().getName())) {
            violations.add("The component name is not set");
        }
        if (component.getBootstrapClassName() == null) {
            violations.add("The component has not defined a boot-strap class name");
        }
        if (component.getBootstrapClassPath() == null || component.getBootstrapClassPath().getPathElements() == null) {
            violations.add("The component has not defined any boot-strap class path elements");
        }
    }

    private static void checkServiceAssembly(List<String> violations, ServiceAssemblyDesc serviceAssembly) {
        if (serviceAssembly.getIdentification() == null) {
            violations.add("The service assembly has not identification");
        } else if (DescriptorFactory.isBlank(serviceAssembly.getIdentification().getName())) {
            violations.add("The service assembly name is not set");
        }
    }

    private static void checkServiceUnit(List<String> violations, Services services) {
    }

    private static void checkSharedLibrary(List<String> violations, SharedLibraryDesc sharedLibrary) {
        if (sharedLibrary.getIdentification() == null) {
            violations.add("The shared library has not identification");
        } else if (DescriptorFactory.isBlank(sharedLibrary.getIdentification().getName())) {
            violations.add("The shared library name is not set");
        }
    }

    public static String getDescriptorAsText(File descriptorFile) {
        if (descriptorFile.isDirectory()) {
            descriptorFile = new File(descriptorFile, DESCRIPTOR_FILE);
        }
        if (descriptorFile.isFile()) {
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                FileInputStream is = new FileInputStream(descriptorFile);
                DescriptorFactory.copyInputStream(is, os);
                return os.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[4096];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }

    public static QName createQName(Element element, String qualifiedName) {
        int index = qualifiedName.indexOf(58);
        if (index >= 0) {
            String prefix = qualifiedName.substring(0, index);
            String localName = qualifiedName.substring(index + 1);
            String uri = DescriptorFactory.recursiveGetAttributeValue(element, "xmlns:" + prefix);
            return new QName(uri, localName, prefix);
        }
        String uri = DescriptorFactory.recursiveGetAttributeValue(element, "xmlns");
        if (uri != null) {
            return new QName(uri, qualifiedName);
        }
        return new QName(qualifiedName);
    }

    public static String recursiveGetAttributeValue(Element element, String attributeName) {
        Node parentNode;
        String answer = null;
        try {
            answer = element.getAttribute(attributeName);
        }
        catch (Exception e) {
            // empty catch block
        }
        if ((answer == null || answer.length() == 0) && (parentNode = element.getParentNode()) instanceof Element) {
            return DescriptorFactory.recursiveGetAttributeValue((Element)parentNode, attributeName);
        }
        return answer;
    }

    public static String getElementText(Element element) {
        StringBuffer buffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3 && node.getNodeType() != 4) continue;
            buffer.append(node.getNodeValue());
        }
        return buffer.toString();
    }

    public static Element getFirstChildElement(Node parent) {
        NodeList childs = parent.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node child = childs.item(i);
            if (!(child instanceof Element)) continue;
            return (Element)child;
        }
        return null;
    }

    public static Element getNextSiblingElement(Element el) {
        for (Node n = el.getNextSibling(); n != null; n = n.getNextSibling()) {
            if (!(n instanceof Element)) continue;
            return (Element)n;
        }
        return null;
    }
}

