/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployer.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.deployer.handler.Transformer;
import org.apache.servicemix.jbi.deployer.handler.URLHandler;
import org.apache.servicemix.jbi.deployer.impl.FileUtil;

public class Connection
extends URLConnection {
    private static Log logger = LogFactory.getLog(Connection.class);
    private URLHandler urlHandler;

    public Connection(URL url, URLHandler urlHandler) {
        super(url);
        this.urlHandler = urlHandler;
    }

    public void connect() {
    }

    public InputStream getInputStream() throws IOException {
        try {
            InputStream targetInputStream = this.urlHandler.getJbiArtifactURL().openConnection().getInputStream();
            File jbiZipFile = File.createTempFile("jbi", ".zip");
            FileOutputStream jbiZip = new FileOutputStream(jbiZipFile);
            FileUtil.copyInputStream(targetInputStream, jbiZip);
            jbiZip.close();
            targetInputStream.close();
            File jbiBundle = File.createTempFile("jbi", ".jar");
            Transformer.transformToOSGiBundle(jbiZipFile, jbiBundle);
            return new FileInputStream(jbiBundle);
        }
        catch (Exception e) {
            logger.error((Object)"Error opening jbi protocol artifact", (Throwable)e);
            throw (IOException)new IOException("Error opening jbi protocol artifact").initCause(e);
        }
    }
}

