/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployer.handler;

import java.io.File;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.deployer.handler.Transformer;
import org.apache.servicemix.kernel.filemonitor.DeploymentListener;

public class JBIDeploymentListener
implements DeploymentListener {
    private static final Log Logger = LogFactory.getLog(JBIDeploymentListener.class);

    public boolean canHandle(File artifact) {
        try {
            if (!artifact.getName().endsWith(".zip") && !artifact.getName().endsWith(".jar")) {
                return false;
            }
            JarFile jar = new JarFile(artifact);
            JarEntry entry = jar.getJarEntry("META-INF/jbi.xml");
            if (entry == null) {
                return false;
            }
            Manifest m = jar.getManifest();
            return m == null || m.getMainAttributes().getValue(new Attributes.Name("Bundle-SymbolicName")) == null || m.getMainAttributes().getValue(new Attributes.Name("Bundle-Version")) == null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public File handle(File artifact, File tmpDir) {
        try {
            String bundleName = artifact.getName().substring(0, artifact.getName().length() - 4) + ".jar";
            File destFile = new File(tmpDir, bundleName);
            if (destFile.exists()) {
                destFile.delete();
            }
            Transformer.transformToOSGiBundle(artifact, destFile);
            return destFile;
        }
        catch (Exception e) {
            Logger.error((Object)("Failed in transforming the JBI artifact to be OSGified. error is: " + e));
            return null;
        }
    }
}

