/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.propertyset.javabeans;

import com.opensymphony.module.propertyset.AbstractPropertySet;
import com.opensymphony.module.propertyset.InvalidPropertyTypeException;
import com.opensymphony.module.propertyset.PropertyException;
import com.opensymphony.module.propertyset.PropertyImplementationException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BeanIntrospectorPropertySet
extends AbstractPropertySet {
    private Map descriptors;
    private Object bean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$util$Properties;

    public void setBean(Object bean) throws PropertyImplementationException {
        this.bean = bean;
        try {
            BeanInfo info = Introspector.getBeanInfo(bean.getClass());
            PropertyDescriptor[] beanDescriptors = info.getPropertyDescriptors();
            int i = 0;
            while (i < beanDescriptors.length) {
                PropertyDescriptor beanDescriptor = beanDescriptors[i];
                this.descriptors.put(beanDescriptor.getName(), beanDescriptor);
                ++i;
            }
        }
        catch (IntrospectionException e) {
            throw new PropertyImplementationException("Object is not a bean", e);
        }
    }

    public Collection getKeys(String prefix, int type) throws PropertyException {
        ArrayList<String> keys = new ArrayList<String>();
        Iterator iter = this.descriptors.values().iterator();
        while (iter.hasNext()) {
            PropertyDescriptor descriptor = (PropertyDescriptor)iter.next();
            if (prefix != null && !descriptor.getName().startsWith(prefix) || type != 0 && this.getType(descriptor.getName()) != type) continue;
            keys.add(descriptor.getName());
        }
        return keys;
    }

    public boolean isSettable(String property) {
        PropertyDescriptor descriptor = (PropertyDescriptor)this.descriptors.get(property);
        boolean bl = false;
        if (descriptor != null && descriptor.getWriteMethod() != null) {
            bl = true;
        }
        return bl;
    }

    public int getType(String key) throws PropertyException {
        Class<?> c;
        block32: {
            block31: {
                block30: {
                    block29: {
                        block28: {
                            block27: {
                                block26: {
                                    block25: {
                                        PropertyDescriptor descriptor = (PropertyDescriptor)this.descriptors.get(key);
                                        if (descriptor == null) {
                                            throw new PropertyException("No key " + key + " found");
                                        }
                                        c = descriptor.getPropertyType();
                                        if (c == Integer.TYPE) break block25;
                                        Class clazz = class$java$lang$Integer;
                                        if (clazz == null) {
                                            clazz = class$java$lang$Integer = BeanIntrospectorPropertySet.class$("[Ljava.lang.Integer;", false);
                                        }
                                        if (c != clazz) break block26;
                                    }
                                    return 2;
                                }
                                if (c == Long.TYPE) break block27;
                                Class clazz = class$java$lang$Long;
                                if (clazz == null) {
                                    clazz = class$java$lang$Long = BeanIntrospectorPropertySet.class$("[Ljava.lang.Long;", false);
                                }
                                if (c != clazz) break block28;
                            }
                            return 3;
                        }
                        if (c == Double.TYPE) break block29;
                        Class clazz = class$java$lang$Double;
                        if (clazz == null) {
                            clazz = class$java$lang$Double = BeanIntrospectorPropertySet.class$("[Ljava.lang.Double;", false);
                        }
                        if (c != clazz) break block30;
                    }
                    return 4;
                }
                Class clazz = class$java$lang$String;
                if (clazz == null) {
                    clazz = class$java$lang$String = BeanIntrospectorPropertySet.class$("[Ljava.lang.String;", false);
                }
                if (c == clazz) {
                    return 5;
                }
                if (c == Boolean.TYPE) break block31;
                Class clazz2 = class$java$lang$Boolean;
                if (clazz2 == null) {
                    clazz2 = class$java$lang$Boolean = BeanIntrospectorPropertySet.class$("[Ljava.lang.Boolean;", false);
                }
                if (c != clazz2) break block32;
            }
            return 1;
        }
        Class clazz = array$B;
        if (clazz == null) {
            clazz = array$B = BeanIntrospectorPropertySet.class$("[B", true);
        }
        if (c == clazz) {
            return 10;
        }
        Class clazz3 = class$java$util$Date;
        if (clazz3 == null) {
            clazz3 = class$java$util$Date = BeanIntrospectorPropertySet.class$("[Ljava.util.Date;", false);
        }
        if (clazz3.isAssignableFrom(c)) {
            return 7;
        }
        Class clazz4 = class$java$util$Properties;
        if (clazz4 == null) {
            clazz4 = class$java$util$Properties = BeanIntrospectorPropertySet.class$("[Ljava.util.Properties;", false);
        }
        if (clazz4.isAssignableFrom(c)) {
            return 11;
        }
        return 8;
    }

    public boolean exists(String key) throws PropertyException {
        boolean bl = false;
        if (this.descriptors.get(key) != null) {
            bl = true;
        }
        return bl;
    }

    public void init(Map config, Map args) {
        Object bean = args.get("bean");
        this.setBean(bean);
    }

    public void remove(String key) throws PropertyException {
        throw new PropertyImplementationException("Remove not supported in BeanIntrospectorPropertySet, use setXXX(null) instead");
    }

    protected void setImpl(int type, String key, Object value) throws PropertyException {
        if (this.getType(key) != type) {
            throw new InvalidPropertyTypeException(key + " is not of type " + type);
        }
        PropertyDescriptor descriptor = (PropertyDescriptor)this.descriptors.get(key);
        try {
            Object result = descriptor.getWriteMethod().invoke(this.bean, value);
        }
        catch (NullPointerException ex) {
            throw new PropertyImplementationException("Property " + key + " is read-only");
        }
        catch (Exception ex) {
            throw new PropertyImplementationException("Cannot invoke write method for key " + key, ex);
        }
    }

    protected Object get(int type, String key) throws PropertyException {
        if (this.getType(key) != type) {
            throw new InvalidPropertyTypeException(key + " is not of type " + type);
        }
        PropertyDescriptor descriptor = (PropertyDescriptor)this.descriptors.get(key);
        try {
            Object result = descriptor.getReadMethod().invoke(this.bean, new Object[0]);
            return result;
        }
        catch (NullPointerException ex) {
            throw new PropertyImplementationException("Property " + key + " is write-only");
        }
        catch (Exception ex) {
            throw new PropertyImplementationException("Cannot invoke read method for key " + key, ex);
        }
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.descriptors = new HashMap();
        this.bean = null;
    }

    public BeanIntrospectorPropertySet() {
        this.this();
    }
}

