/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.config;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanReferenceFactoryBean;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Conventions;
import org.springframework.core.enums.StaticLabeledEnumResolver;
import org.springframework.osgi.config.OsgiDefaultsDefinition;
import org.springframework.osgi.config.ParserUtils;
import org.springframework.osgi.service.importer.support.Cardinality;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class AbstractReferenceDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String LISTENERS_PROP = "listeners";
    private static final String CARDINALITY_PROP = "cardinality";
    private static final String SERVICE_BEAN_NAME_PROP = "serviceBeanName";
    private static final String INTERFACES_PROP = "interfaces";
    private static final String CCL_PROP = "contextClassLoader";
    private static final String TARGET_BEAN_NAME_PROP = "targetBeanName";
    private static final String TARGET_PROP = "target";
    private static final String LISTENER = "listener";
    private static final String REF = "ref";
    private static final String INTERFACE = "interface";
    private static final String INTERFACES = "interfaces";
    private static final String CARDINALITY = "cardinality";
    private static final String ZERO = "0";
    private static final String SERVICE_BEAN_NAME = "bean-name";
    private static final String CONTEXT_CLASSLOADER = "context-class-loader";
    protected OsgiDefaultsDefinition defaults = null;
    static /* synthetic */ Class class$org$springframework$osgi$config$OsgiServiceLifecycleListenerAdapter;

    AbstractReferenceDefinitionParser() {
    }

    private OsgiDefaultsDefinition resolveDefaults(Document document) {
        if (this.defaults == null) {
            this.defaults = ParserUtils.initOsgiDefaults(document);
        }
        return this.defaults;
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition();
        Class beanClass = this.getBeanClass(element);
        Assert.notNull((Object)beanClass);
        if (beanClass != null) {
            builder.getRawBeanDefinition().setBeanClass(beanClass);
        }
        builder.getRawBeanDefinition().setSource(parserContext.extractSource((Object)element));
        if (parserContext.isNested()) {
            builder.setScope(parserContext.getContainingBeanDefinition().getScope());
        }
        if (parserContext.isDefaultLazyInit()) {
            builder.setLazyInit(true);
        }
        this.doParse(element, parserContext, builder);
        AbstractBeanDefinition def = builder.getBeanDefinition();
        if (parserContext.isNested()) {
            StringBuffer id = new StringBuffer();
            String value = element.getAttribute("id");
            if (StringUtils.hasText((String)value)) {
                id.append(value);
                id.append("#");
            }
            id.append(parserContext.getReaderContext().generateBeanName((BeanDefinition)def));
            BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)def, id.toString());
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)parserContext.getRegistry());
            return this.createBeanReferenceDefinition(id.toString());
        }
        return def;
    }

    private AbstractBeanDefinition createBeanReferenceDefinition(String beanName) {
        GenericBeanDefinition def = new GenericBeanDefinition();
        def.setBeanClass(BeanReferenceFactoryBean.class);
        MutablePropertyValues mpv = new MutablePropertyValues();
        mpv.addPropertyValue(TARGET_BEAN_NAME_PROP, (Object)beanName);
        def.setPropertyValues(mpv);
        return def;
    }

    protected void doParse(Element element, ParserContext context, BeanDefinitionBuilder builder) {
        if (this.defaults == null) {
            this.resolveDefaults(element.getOwnerDocument());
        }
        ReferenceAttributesCallback callback = new ReferenceAttributesCallback();
        this.parseAttributes(element, builder, new ParserUtils.AttributeCallback[]{callback});
        if (!callback.isCardinalitySpecified) {
            this.applyDefaultCardinality(builder, this.defaults);
        }
        this.parseNestedElements(element, context, builder);
        this.handleNestedDefinition(element, context, builder);
    }

    protected void handleNestedDefinition(Element element, ParserContext context, BeanDefinitionBuilder builder) {
    }

    protected void parseAttributes(Element element, BeanDefinitionBuilder builder, ParserUtils.AttributeCallback[] callbacks) {
        ParserUtils.parseCustomAttributes(element, builder, callbacks);
    }

    protected abstract String mandatoryCardinality();

    protected abstract String optionalCardinality();

    protected abstract Class getBeanClass(Element var1);

    protected Object determineCardinality(String value) {
        return this.processCardinalityString(value.startsWith(ZERO) ? this.optionalCardinality() : this.mandatoryCardinality());
    }

    private Cardinality processCardinalityString(String value) {
        return (Cardinality)StaticLabeledEnumResolver.instance().getLabeledEnumByLabel(Cardinality.class, value.toUpperCase(Locale.ENGLISH));
    }

    protected void applyDefaultCardinality(BeanDefinitionBuilder builder, OsgiDefaultsDefinition defaults) {
        builder.addPropertyValue("cardinality", this.determineCardinality(defaults.getCardinality()));
    }

    protected void parseNestedElements(Element element, ParserContext context, BeanDefinitionBuilder builder) {
        this.parseInterfaces(element, context, builder);
        this.parseListeners(element, context, builder);
    }

    protected void parseInterfaces(Element parent, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Element element = DomUtils.getChildElementByTagName((Element)parent, (String)"interfaces");
        if (element != null) {
            if (parent.hasAttribute(INTERFACE)) {
                parserContext.getReaderContext().error("either 'interface' attribute or <intefaces> sub-element has be specified", (Object)parent);
            }
            Set interfaces = parserContext.getDelegate().parseSetElement(element, (BeanDefinition)builder.getBeanDefinition());
            builder.addPropertyValue("interfaces", (Object)interfaces);
        }
    }

    protected void parseListeners(Element element, ParserContext context, BeanDefinitionBuilder builder) {
        List listeners = DomUtils.getChildElementsByTagName((Element)element, (String)LISTENER);
        ManagedList listenersRef = new ManagedList();
        Iterator iter = listeners.iterator();
        while (iter.hasNext()) {
            Element listnr = (Element)iter.next();
            Object target = null;
            String targetName = null;
            NodeList nl = listnr.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node node = nl.item(i);
                if (!(node instanceof Element)) continue;
                Element beanDef = (Element)node;
                if (listnr.hasAttribute(REF)) {
                    context.getReaderContext().error("nested bean declaration is not allowed if 'ref' attribute has been specified", (Object)beanDef);
                }
                if (!((target = context.getDelegate().parsePropertySubElement(beanDef, (BeanDefinition)builder.getBeanDefinition())) instanceof RuntimeBeanReference)) continue;
                targetName = ((RuntimeBeanReference)target).getBeanName();
            }
            MutablePropertyValues vals = new MutablePropertyValues();
            NamedNodeMap attrs = listnr.getAttributes();
            for (int x = 0; x < attrs.getLength(); ++x) {
                Attr attribute = (Attr)attrs.item(x);
                String name = attribute.getLocalName();
                if (REF.equals(name)) {
                    targetName = attribute.getValue();
                    continue;
                }
                vals.addPropertyValue(Conventions.attributeNameToPropertyName((String)name), (Object)attribute.getValue());
            }
            RootBeanDefinition wrapperDef = new RootBeanDefinition(class$org$springframework$osgi$config$OsgiServiceLifecycleListenerAdapter == null ? AbstractReferenceDefinitionParser.class$("org.springframework.osgi.config.OsgiServiceLifecycleListenerAdapter") : class$org$springframework$osgi$config$OsgiServiceLifecycleListenerAdapter);
            if (targetName != null) {
                vals.addPropertyValue(TARGET_BEAN_NAME_PROP, targetName);
            } else {
                vals.addPropertyValue(TARGET_PROP, target);
            }
            wrapperDef.setPropertyValues(vals);
            listenersRef.add((Object)wrapperDef);
        }
        builder.addPropertyValue(LISTENERS_PROP, (Object)listenersRef);
    }

    class ReferenceAttributesCallback
    implements ParserUtils.AttributeCallback {
        public boolean isCardinalitySpecified = false;

        ReferenceAttributesCallback() {
        }

        public boolean process(Element parent, Attr attribute, BeanDefinitionBuilder builder) {
            String name = attribute.getLocalName();
            String value = attribute.getValue();
            if ("cardinality".equals(name)) {
                this.isCardinalitySpecified = true;
                builder.addPropertyValue("cardinality", AbstractReferenceDefinitionParser.this.determineCardinality(value));
                return false;
            }
            if (AbstractReferenceDefinitionParser.SERVICE_BEAN_NAME.equals(name)) {
                builder.addPropertyValue(AbstractReferenceDefinitionParser.SERVICE_BEAN_NAME_PROP, (Object)value);
                return false;
            }
            if (AbstractReferenceDefinitionParser.INTERFACE.equals(name)) {
                builder.addPropertyValue("interfaces", (Object)value);
                return false;
            }
            if (AbstractReferenceDefinitionParser.CONTEXT_CLASSLOADER.equals(name)) {
                String val = value.toUpperCase(Locale.ENGLISH).replace('-', '_');
                builder.addPropertyValue(AbstractReferenceDefinitionParser.CCL_PROP, (Object)val);
                return false;
            }
            return true;
        }
    }
}

