/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.context.support;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.springframework.osgi.util.OsgiFilterUtils;
import org.springframework.osgi.util.OsgiServiceReferenceUtils;

abstract class TrackingUtil {
    TrackingUtil() {
    }

    static Object getService(Class[] classes, String filter, ClassLoader classLoader, BundleContext context, Object fallbackObject) {
        String flt = OsgiFilterUtils.unifyFilter(classes, filter);
        return Proxy.newProxyInstance(classLoader, classes, (InvocationHandler)new OsgiServiceHandler(fallbackObject, context, flt));
    }

    private static class OsgiServiceHandler
    implements InvocationHandler {
        private final Object fallbackObject;
        private final BundleContext context;
        private final String filter;
        private boolean bundleContextInvalidated = false;

        public OsgiServiceHandler(Object fallbackObject, BundleContext bundleContext, String filter) {
            this.fallbackObject = fallbackObject;
            this.context = bundleContext;
            this.filter = filter;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(System.identityHashCode(proxy));
            }
            Object target = null;
            if (!this.bundleContextInvalidated) {
                try {
                    ServiceReference ref = OsgiServiceReferenceUtils.getServiceReference(this.context, this.filter);
                    target = ref != null ? this.context.getService(ref) : null;
                }
                catch (IllegalStateException ise) {
                    this.bundleContextInvalidated = true;
                }
            }
            if (target == null) {
                target = this.fallbackObject;
            }
            try {
                Object result = method.invoke(target, args);
                return result;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

