/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.importer.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceReference;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.osgi.service.importer.ImportedOsgiServiceProxy;
import org.springframework.osgi.service.importer.OsgiServiceLifecycleListener;
import org.springframework.osgi.service.importer.support.AbstractServiceImporterProxyFactoryBean;
import org.springframework.osgi.service.importer.support.AbstractServiceProxyCreator;
import org.springframework.osgi.service.importer.support.Cardinality;
import org.springframework.osgi.service.importer.support.DisposableBeanRunnableAdapter;
import org.springframework.osgi.service.importer.support.internal.aop.ProxyPlusCallback;
import org.springframework.osgi.service.importer.support.internal.aop.ServiceDynamicInterceptor;
import org.springframework.osgi.service.importer.support.internal.aop.ServiceInvoker;
import org.springframework.osgi.service.importer.support.internal.aop.ServiceProviderTCCLInterceptor;
import org.springframework.osgi.service.importer.support.internal.controller.ImporterController;
import org.springframework.osgi.service.importer.support.internal.controller.ImporterInternalActions;
import org.springframework.osgi.service.importer.support.internal.dependency.ImporterStateListener;
import org.springframework.osgi.service.importer.support.internal.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public final class OsgiServiceProxyFactoryBean
extends AbstractServiceImporterProxyFactoryBean
implements ApplicationEventPublisherAware {
    private static final Log log = LogFactory.getLog((Class)OsgiServiceProxyFactoryBean.class);
    private RetryTemplate retryTemplate = new RetryTemplate();
    private ImportedOsgiServiceProxy proxy;
    private Runnable destructionCallback;
    private ApplicationEventPublisher applicationEventPublisher;
    private final List stateListeners = Collections.synchronizedList(new ArrayList(4));
    private final ImporterInternalActions controller = new ImporterController(new Executor());
    private boolean mandatory;

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (this.getCardinality() == null) {
            this.setCardinality(Cardinality.C_1__1);
        }
    }

    public Class getObjectType() {
        Class clazz = this.proxy != null ? this.proxy.getClass() : (ObjectUtils.isEmpty((Object[])this.getInterfaces()) ? Object.class : this.getInterfaces()[0]);
        return clazz;
    }

    public Object getObject() {
        return super.getObject();
    }

    Object createProxy() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating a single service proxy ...");
        }
        final ServiceProviderTCCLInterceptor tcclAdvice = new ServiceProviderTCCLInterceptor();
        ServiceProviderTCCLInterceptor.ServiceProviderTCCLListener tcclListener = new ServiceProviderTCCLInterceptor.ServiceProviderTCCLListener(tcclAdvice);
        final ServiceDynamicInterceptor lookupAdvice = new ServiceDynamicInterceptor(this.getBundleContext(), this.getUnifiedFilter(), this.getAopClassLoader());
        lookupAdvice.setRequiredAtStartup(this.getCardinality().isMandatory());
        OsgiServiceLifecycleListener[] listeners = this.addListener(this.getListeners(), tcclListener);
        lookupAdvice.setListeners(listeners);
        lookupAdvice.setRetryTemplate(new RetryTemplate(this.retryTemplate));
        lookupAdvice.setApplicationEventPublisher(this.applicationEventPublisher);
        lookupAdvice.setStateListeners(this.stateListeners);
        lookupAdvice.setServiceImporter(this);
        AbstractServiceProxyCreator creator = new AbstractServiceProxyCreator(this.getInterfaces(), this.getAopClassLoader(), this.getBundleContext(), this.getContextClassLoader()){

            ServiceInvoker createDispatcherInterceptor(ServiceReference reference) {
                return lookupAdvice;
            }

            Advice createServiceProviderTCCLAdvice(ServiceReference reference) {
                return tcclAdvice;
            }
        };
        ProxyPlusCallback proxyPlusCallback = creator.createServiceProxy(lookupAdvice.getServiceReference());
        this.proxy = proxyPlusCallback.proxy;
        this.destructionCallback = new DisposableBeanRunnableAdapter(proxyPlusCallback.destructionCallback);
        lookupAdvice.setProxy(this.proxy);
        lookupAdvice.afterPropertiesSet();
        return this.proxy;
    }

    Runnable getProxyDestructionCallback() {
        return this.destructionCallback;
    }

    private OsgiServiceLifecycleListener[] addListener(OsgiServiceLifecycleListener[] listeners, OsgiServiceLifecycleListener listener) {
        int size = listeners == null ? 1 : listeners.length + 1;
        OsgiServiceLifecycleListener[] list = new OsgiServiceLifecycleListener[size];
        list[0] = listener;
        if (listeners != null) {
            System.arraycopy(listeners, 0, list, 1, listeners.length);
        }
        return list;
    }

    public void setRetryTimes(int maxRetries) {
        this.retryTemplate.setRetryNumbers(maxRetries);
    }

    public int getRetryTimes() {
        return this.retryTemplate.getRetryNumbers();
    }

    public void setTimeout(long millisBetweenRetries) {
        this.retryTemplate.setWaitTime(millisBetweenRetries);
    }

    public long getTimeout() {
        return this.retryTemplate.getWaitTime();
    }

    public void setCardinality(Cardinality cardinality) {
        Assert.notNull((Object)((Object)cardinality));
        Assert.isTrue((boolean)cardinality.isSingle(), (String)"only singular cardinality ('X..1') accepted");
        super.setCardinality(cardinality);
        this.mandatory = cardinality.isMandatory();
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    private class Executor
    implements ImporterInternalActions {
        private Executor() {
        }

        public void addStateListener(ImporterStateListener stateListener) {
            OsgiServiceProxyFactoryBean.this.stateListeners.add(stateListener);
        }

        public void removeStateListener(ImporterStateListener stateListener) {
            OsgiServiceProxyFactoryBean.this.stateListeners.remove(stateListener);
        }

        public boolean isSatisfied() {
            if (!OsgiServiceProxyFactoryBean.this.mandatory) {
                return true;
            }
            return OsgiServiceProxyFactoryBean.this.proxy == null ? true : OsgiServiceProxyFactoryBean.this.proxy.getServiceReference().getBundle() != null;
        }
    }
}

