/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.util.ExchangeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.camel.JbiExchange;

public class JbiBinding {
    private static final Log LOG = LogFactory.getLog(JbiBinding.class);
    private String messageExchangePattern;

    public Object extractBodyFromJbi(JbiExchange exchange, NormalizedMessage normalizedMessage) {
        return normalizedMessage.getContent();
    }

    public Source convertBodyToJbi(Exchange exchange, Object body) {
        if (body instanceof Source) {
            return (Source)body;
        }
        try {
            return (Source)ExchangeHelper.convertToType((Exchange)exchange, Source.class, (Object)body);
        }
        catch (NoTypeConversionAvailableException e) {
            LOG.warn((Object)("Unable to convert message body of type " + body.getClass() + " into an XML Source"));
            return null;
        }
    }

    public MessageExchange makeJbiMessageExchange(Exchange camelExchange, MessageExchangeFactory exchangeFactory, String defaultMep) throws MessagingException, URISyntaxException {
        MessageExchange jbiExchange = this.createJbiMessageExchange(camelExchange, exchangeFactory, defaultMep);
        NormalizedMessage normalizedMessage = jbiExchange.getMessage("in");
        if (normalizedMessage == null) {
            normalizedMessage = jbiExchange.createMessage();
            jbiExchange.setMessage(normalizedMessage, "in");
        }
        normalizedMessage.setContent(this.getJbiInContent(camelExchange));
        this.addJbiHeaders(jbiExchange, normalizedMessage, camelExchange);
        this.addJbiAttachments(jbiExchange, normalizedMessage, camelExchange);
        return jbiExchange;
    }

    public String getMessageExchangePattern() {
        return this.messageExchangePattern;
    }

    public void setMessageExchangePattern(String messageExchangePattern) {
        this.messageExchangePattern = messageExchangePattern;
    }

    protected MessageExchange createJbiMessageExchange(Exchange camelExchange, MessageExchangeFactory exchangeFactory, String defaultMep) throws MessagingException, URISyntaxException {
        ExchangePattern mep = ExchangePattern.fromWsdlUri((String)defaultMep);
        if (mep == null) {
            mep = ExchangePattern.fromWsdlUri((String)this.getMessageExchangePattern());
        }
        if (mep == null) {
            mep = camelExchange.getPattern();
        }
        Object answer = null;
        if (mep != null) {
            answer = mep == ExchangePattern.InOnly ? exchangeFactory.createInOnlyExchange() : (mep == ExchangePattern.InOptionalOut ? exchangeFactory.createInOptionalOutExchange() : (mep == ExchangePattern.InOut ? exchangeFactory.createInOutExchange() : (mep == ExchangePattern.RobustInOnly ? exchangeFactory.createRobustInOnlyExchange() : exchangeFactory.createExchange(new URI(mep.toString())))));
        }
        if (answer == null) {
            Message out = camelExchange.getOut(false);
            answer = out == null || out.getBody() == null ? exchangeFactory.createInOnlyExchange() : exchangeFactory.createInOutExchange();
        }
        if (camelExchange.getProperty("jbi.operation") != null) {
            String operationName = (String)camelExchange.getProperty("jbi.operation");
            QName operationQName = QName.valueOf(operationName);
            answer.setOperation(operationQName);
        }
        return answer;
    }

    protected Source getJbiInContent(Exchange camelExchange) {
        Source content = (Source)camelExchange.getIn().getBody(Source.class);
        if (content == null && camelExchange.getIn().getBody() != null) {
            LOG.warn((Object)("'in' message content of type " + camelExchange.getIn().getBody().getClass() + " could not be converted to Source and will be dropped"));
        }
        return content;
    }

    protected void addJbiHeaders(MessageExchange jbiExchange, NormalizedMessage normalizedMessage, Exchange camelExchange) {
        Set entries = camelExchange.getIn().getHeaders().entrySet();
        for (Map.Entry entry : entries) {
            normalizedMessage.setProperty((String)entry.getKey(), entry.getValue());
            if (!(entry.getValue() instanceof Serializable) || entry.getValue() instanceof Map || entry.getValue() instanceof Collection) continue;
            normalizedMessage.setProperty((String)entry.getKey(), entry.getValue());
        }
    }

    protected void addJbiAttachments(MessageExchange jbiExchange, NormalizedMessage normalizedMessage, Exchange camelExchange) throws MessagingException {
        Set entries = camelExchange.getIn().getAttachments().entrySet();
        for (Map.Entry entry : entries) {
            normalizedMessage.addAttachment((String)entry.getKey(), (DataHandler)entry.getValue());
        }
    }
}

