/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel;

import java.net.URISyntaxException;
import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.URISupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.camel.CamelConsumerEndpoint;
import org.apache.servicemix.camel.CamelJbiComponent;
import org.apache.servicemix.camel.CamelProviderEndpoint;
import org.apache.servicemix.camel.JbiBinding;
import org.apache.servicemix.camel.JbiException;
import org.apache.servicemix.camel.JbiExchange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbiEndpoint
extends DefaultEndpoint<Exchange> {
    private String destinationUri;
    private String mep;
    private String operation;
    private JbiProducer producer;
    private final CamelJbiComponent jbiComponent;

    public JbiEndpoint(CamelJbiComponent jbiComponent, String uri) {
        super(uri, (Component)jbiComponent);
        this.jbiComponent = jbiComponent;
        this.parseUri(uri);
    }

    public synchronized Producer<Exchange> createProducer() throws Exception {
        if (this.producer == null) {
            this.producer = new JbiProducer((Endpoint<Exchange>)this);
        }
        return this.producer;
    }

    private void parseUri(String uri) {
        this.destinationUri = uri;
        try {
            int idx = this.destinationUri.indexOf(63);
            if (idx > 0) {
                Map params = URISupport.parseQuery((String)this.destinationUri.substring(idx + 1));
                this.mep = (String)params.get("mep");
                if (this.mep != null && !this.mep.startsWith("http://www.w3.org/ns/wsdl/")) {
                    this.mep = "http://www.w3.org/ns/wsdl/" + this.mep;
                }
                this.operation = (String)params.get("operation");
                this.destinationUri = this.destinationUri.substring(0, idx);
            }
        }
        catch (URISyntaxException e) {
            throw new JbiException(e);
        }
    }

    public void setMep(String str) {
        this.mep = str;
    }

    public void setOperation(String str) {
        this.operation = str;
    }

    public void setDestionationUri(String str) {
        this.destinationUri = str;
    }

    public String getMep() {
        return this.mep;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getDestinationUri() {
        return this.destinationUri;
    }

    public Consumer<Exchange> createConsumer(final Processor processor) throws Exception {
        return new DefaultConsumer<Exchange>((Endpoint)this, processor){
            CamelProviderEndpoint jbiEndpoint;

            protected void doStart() throws Exception {
                super.doStart();
                this.jbiEndpoint = JbiEndpoint.this.jbiComponent.activateJbiEndpoint((Endpoint)JbiEndpoint.this, processor);
            }

            protected void doStop() throws Exception {
                if (this.jbiEndpoint != null) {
                    JbiEndpoint.this.jbiComponent.deactivateJbiEndpoint(this.jbiEndpoint);
                }
                super.doStop();
            }
        };
    }

    public JbiExchange createExchange() {
        return new JbiExchange(this.getCamelContext(), this.getBinding());
    }

    public JbiBinding getBinding() {
        return this.jbiComponent.getBinding();
    }

    public boolean isSingleton() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class JbiProducer
    extends DefaultProducer<Exchange>
    implements AsyncProcessor {
        private final Log log;
        private CamelConsumerEndpoint consumer;

        public JbiProducer(Endpoint<Exchange> exchangeEndpoint) {
            super(exchangeEndpoint);
            this.log = LogFactory.getLog(JbiProducer.class);
        }

        public void start() throws Exception {
            this.consumer = new CamelConsumerEndpoint(JbiEndpoint.this.jbiComponent.getBinding(), JbiEndpoint.this);
            JbiEndpoint.this.jbiComponent.addEndpoint((org.apache.servicemix.common.Endpoint)this.consumer);
            super.start();
        }

        public void stop() throws Exception {
            if (this.isStopped()) {
                this.log.debug((Object)("Camel producer for " + super.getEndpoint() + " has already been stopped"));
            } else {
                this.log.debug((Object)("Stopping Camel producer for " + super.getEndpoint()));
                JbiEndpoint.this.jbiComponent.removeEndpoint((org.apache.servicemix.common.Endpoint)this.consumer);
                super.stop();
            }
        }

        public void process(Exchange exchange) throws Exception {
            this.consumer.process(exchange);
        }

        public boolean process(Exchange exchange, AsyncCallback asyncCallback) {
            return this.consumer.process(exchange, asyncCallback);
        }
    }
}

