/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.jbi;

import javax.xml.namespace.QName;
import org.apache.cxf.binding.AbstractBindingFactory;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.binding.jbi.JBIBinding;
import org.apache.cxf.binding.jbi.JBIBindingInfo;
import org.apache.cxf.binding.jbi.interceptor.JBIFaultInInterceptor;
import org.apache.cxf.binding.jbi.interceptor.JBIFaultOutInterceptor;
import org.apache.cxf.binding.jbi.interceptor.JBIOperationInInterceptor;
import org.apache.cxf.binding.jbi.interceptor.JBIWrapperInInterceptor;
import org.apache.cxf.binding.jbi.interceptor.JBIWrapperOutInterceptor;
import org.apache.cxf.interceptor.StaxInInterceptor;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;

public class JBIBindingFactory
extends AbstractBindingFactory {
    public Binding createBinding(BindingInfo binding) {
        JBIBinding jb = new JBIBinding((JBIBindingInfo)binding);
        jb.getInInterceptors().add(new StaxInInterceptor());
        jb.getInInterceptors().add(new JBIOperationInInterceptor());
        jb.getInInterceptors().add(new JBIWrapperInInterceptor());
        jb.getOutInterceptors().add(new StaxOutInterceptor());
        jb.getOutInterceptors().add(new JBIWrapperOutInterceptor());
        jb.getOutFaultInterceptors().add(new StaxOutInterceptor());
        jb.getOutFaultInterceptors().add(new JBIFaultOutInterceptor());
        jb.getInFaultInterceptors().add(new JBIFaultInInterceptor());
        return jb;
    }

    public BindingInfo createBindingInfo(ServiceInfo service, String namespace, Object config) {
        JBIBindingInfo info = new JBIBindingInfo(service, "http://cxf.apache.org/bindings/jbi");
        info.setName(new QName(service.getName().getNamespaceURI(), service.getName().getLocalPart() + "JBIBinding"));
        for (OperationInfo op : service.getInterface().getOperations()) {
            BindingOperationInfo bop = info.buildOperation(op.getName(), op.getInputName(), op.getOutputName());
            info.addOperation(bop);
        }
        return info;
    }
}

