/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.slf4j;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.ops4j.pax.logging.DefaultServiceLog;
import org.ops4j.pax.logging.OSGIPaxLoggingManager;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingManager;
import org.ops4j.pax.logging.slf4j.Slf4jLogger;
import org.osgi.framework.BundleContext;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

public class Slf4jLoggerFactory
implements ILoggerFactory {
    private static PaxLoggingManager m_paxLogging;
    private static WeakHashMap m_loggers;

    public static void setBundleContext(BundleContext context) {
        m_paxLogging = new OSGIPaxLoggingManager(context);
        Set entrySet = m_loggers.entrySet();
        Iterator iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = (String)entry.getValue();
            Slf4jLogger logger = (Slf4jLogger)entry.getKey();
            logger.setPaxLoggingManager(m_paxLogging, name);
        }
        m_paxLogging.open();
    }

    public static void release() {
        m_paxLogging.close();
        m_paxLogging.dispose();
    }

    public Logger getLogger(String name) {
        PaxLogger paxLogger = m_paxLogging == null ? new DefaultServiceLog(null, name) : m_paxLogging.getLogger(name, Slf4jLogger.SLF4J_FQCN);
        Slf4jLogger logger = new Slf4jLogger(name, paxLogger);
        m_loggers.put(logger, name);
        return logger;
    }

    static {
        m_loggers = new WeakHashMap();
    }
}

