/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.ext.posix.POSIX;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyModule(name={"Process"})
public class RubyProcess {
    private static String[] signals = new String[]{"EXIT", "HUP", "INT", "QUIT", "ILL", "TRAP", "ABRT", "POLL", "FPE", "KILL", "BUS", "SEGV", "SYS", "PIPE", "ALRM", "TERM", "URG", "STOP", "TSTP", "CONT", "CHLD", "TTIN", "TTOU", "XCPU", "XFSZ", "VTALRM", "PROF", "USR1", "USR2"};

    public static RubyModule createProcessModule(Ruby runtime) {
        RubyModule process = runtime.defineModule("Process");
        runtime.setProcess(process);
        RubyClass process_status = process.defineClassUnder("Status", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setProcStatus(process_status);
        RubyModule process_uid = process.defineModuleUnder("UID");
        runtime.setProcUID(process_uid);
        RubyModule process_gid = process.defineModuleUnder("GID");
        runtime.setProcGID(process_gid);
        RubyModule process_sys = process.defineModuleUnder("Sys");
        runtime.setProcSys(process_sys);
        process.defineAnnotatedMethods(RubyProcess.class);
        process_status.defineAnnotatedMethods(RubyStatus.class);
        process_uid.defineAnnotatedMethods(UserID.class);
        process_gid.defineAnnotatedMethods(GroupID.class);
        process_sys.defineAnnotatedMethods(Sys.class);
        process.defineConstant("PRIO_PROCESS", runtime.newFixnum(0));
        process.defineConstant("PRIO_PGRP", runtime.newFixnum(1));
        process.defineConstant("PRIO_USER", runtime.newFixnum(2));
        process.defineConstant("WNOHANG", runtime.newFixnum(1));
        return process;
    }

    @JRubyMethod(name={"abort"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject abort(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
        return RubyKernel.abort(context, recv, args);
    }

    @JRubyMethod(name={"exit!"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject exit_bang(IRubyObject recv, IRubyObject[] args) {
        return RubyKernel.exit_bang(recv, args);
    }

    @JRubyMethod(name={"groups"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject groups(IRubyObject recv) {
        throw recv.getRuntime().newNotImplementedError("Process#groups not yet implemented");
    }

    @JRubyMethod(name={"setrlimit"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setrlimit(IRubyObject recv, IRubyObject[] args) {
        throw recv.getRuntime().newNotImplementedError("Process#setrlimit not yet implemented");
    }

    @JRubyMethod(name={"getpgrp"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject getpgrp(IRubyObject recv) {
        return recv.getRuntime().newFixnum(recv.getRuntime().getPosix().getpgrp());
    }

    @JRubyMethod(name={"groups="}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject groups_set(IRubyObject recv, IRubyObject arg) {
        throw recv.getRuntime().newNotImplementedError("Process#groups not yet implemented");
    }

    @JRubyMethod(name={"waitpid"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject waitpid(IRubyObject recv, IRubyObject[] args) {
        Ruby runtime = recv.getRuntime();
        int pid = -1;
        int flags = 0;
        if (args.length > 0) {
            pid = (int)args[0].convertToInteger().getLongValue();
        }
        if (args.length > 1) {
            flags = (int)args[1].convertToInteger().getLongValue();
        }
        int[] status = new int[1];
        pid = runtime.getPosix().waitpid(pid, status, flags);
        if (pid == -1) {
            throw runtime.newErrnoECHILDError();
        }
        runtime.getGlobalVariables().set("$?", RubyStatus.newProcessStatus(runtime, status[0]));
        return runtime.newFixnum(pid);
    }

    @JRubyMethod(name={"wait"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject wait(IRubyObject recv, IRubyObject[] args) {
        Ruby runtime = recv.getRuntime();
        if (args.length > 0) {
            return RubyProcess.waitpid(recv, args);
        }
        int[] status = new int[1];
        int pid = runtime.getPosix().wait(status);
        if (pid == -1) {
            throw runtime.newErrnoECHILDError();
        }
        runtime.getGlobalVariables().set("$?", RubyStatus.newProcessStatus(runtime, status[0]));
        return runtime.newFixnum(pid);
    }

    @JRubyMethod(name={"waitall"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject waitall(IRubyObject recv) {
        Ruby runtime = recv.getRuntime();
        POSIX posix = runtime.getPosix();
        RubyArray results = recv.getRuntime().newArray();
        int[] status = new int[1];
        int result = posix.wait(status);
        while (result != -1) {
            results.append(runtime.newArray(runtime.newFixnum(result), RubyStatus.newProcessStatus(runtime, status[0])));
            result = posix.wait(status);
        }
        return results;
    }

    @JRubyMethod(name={"setsid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setsid(IRubyObject recv) {
        return recv.getRuntime().newFixnum(recv.getRuntime().getPosix().setsid());
    }

    @JRubyMethod(name={"setpgrp"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setpgrp(IRubyObject recv) {
        return recv.getRuntime().newFixnum(recv.getRuntime().getPosix().setpgid(0, 0));
    }

    @JRubyMethod(name={"egid="}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject egid_set(IRubyObject recv, IRubyObject arg) {
        recv.getRuntime().getPosix().setegid((int)arg.convertToInteger().getLongValue());
        return RubyFixnum.zero(recv.getRuntime());
    }

    @JRubyMethod(name={"euid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject euid(IRubyObject recv) {
        return recv.getRuntime().newFixnum(recv.getRuntime().getPosix().geteuid());
    }

    @JRubyMethod(name={"uid="}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject uid_set(IRubyObject recv, IRubyObject arg) {
        recv.getRuntime().getPosix().setuid((int)arg.convertToInteger().getLongValue());
        return RubyFixnum.zero(recv.getRuntime());
    }

    @JRubyMethod(name={"gid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject gid(IRubyObject recv) {
        return recv.getRuntime().newFixnum(recv.getRuntime().getPosix().getgid());
    }

    @JRubyMethod(name={"maxgroups"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject maxgroups(IRubyObject recv) {
        throw recv.getRuntime().newNotImplementedError("Process#maxgroups not yet implemented");
    }

    @JRubyMethod(name={"getpriority"}, required=2, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject getpriority(IRubyObject recv, IRubyObject arg1, IRubyObject arg2) {
        int which = (int)arg1.convertToInteger().getLongValue();
        int who = (int)arg2.convertToInteger().getLongValue();
        int result = recv.getRuntime().getPosix().getpriority(which, who);
        return recv.getRuntime().newFixnum(result);
    }

    @JRubyMethod(name={"uid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject uid(IRubyObject recv) {
        return recv.getRuntime().newFixnum(recv.getRuntime().getPosix().getuid());
    }

    @JRubyMethod(name={"waitpid2"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject waitpid2(IRubyObject recv, IRubyObject[] args) {
        Ruby runtime = recv.getRuntime();
        int pid = -1;
        int flags = 0;
        if (args.length > 0) {
            pid = (int)args[0].convertToInteger().getLongValue();
        }
        if (args.length > 1) {
            flags = (int)args[1].convertToInteger().getLongValue();
        }
        int[] status = new int[1];
        pid = runtime.getPosix().waitpid(pid, status, flags);
        if (pid == -1) {
            throw runtime.newErrnoECHILDError();
        }
        return runtime.newArray(runtime.newFixnum(pid), RubyStatus.newProcessStatus(runtime, status[0]));
    }

    @JRubyMethod(name={"initgroups"}, required=2, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject initgroups(IRubyObject recv, IRubyObject arg1, IRubyObject arg2) {
        throw recv.getRuntime().newNotImplementedError("Process#initgroups not yet implemented");
    }

    @JRubyMethod(name={"maxgroups="}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject maxgroups_set(IRubyObject recv, IRubyObject arg) {
        throw recv.getRuntime().newNotImplementedError("Process#maxgroups_set not yet implemented");
    }

    @JRubyMethod(name={"ppid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject ppid(IRubyObject recv) {
        return recv.getRuntime().newFixnum(recv.getRuntime().getPosix().getppid());
    }

    @JRubyMethod(name={"gid="}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject gid_set(IRubyObject recv, IRubyObject arg) {
        return recv.getRuntime().newFixnum(recv.getRuntime().getPosix().setgid((int)arg.convertToInteger().getLongValue()));
    }

    @JRubyMethod(name={"wait2"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject wait2(IRubyObject recv, IRubyObject[] args) {
        return RubyProcess.waitpid2(recv, args);
    }

    @JRubyMethod(name={"euid="}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject euid_set(IRubyObject recv, IRubyObject arg) {
        recv.getRuntime().getPosix().seteuid((int)arg.convertToInteger().getLongValue());
        return RubyFixnum.zero(recv.getRuntime());
    }

    @JRubyMethod(name={"setpriority"}, required=3, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setpriority(IRubyObject recv, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        int which = (int)arg1.convertToInteger().getLongValue();
        int who = (int)arg2.convertToInteger().getLongValue();
        int prio = (int)arg3.convertToInteger().getLongValue();
        int result = recv.getRuntime().getPosix().setpriority(which, who, prio);
        return recv.getRuntime().newFixnum(result);
    }

    @JRubyMethod(name={"setpgid"}, required=2, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setpgid(IRubyObject recv, IRubyObject arg1, IRubyObject arg2) {
        int pid = (int)arg1.convertToInteger().getLongValue();
        int gid = (int)arg2.convertToInteger().getLongValue();
        return recv.getRuntime().newFixnum(recv.getRuntime().getPosix().setpgid(pid, gid));
    }

    @JRubyMethod(name={"getpgid"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject getpgid(IRubyObject recv, IRubyObject arg) {
        return recv.getRuntime().newFixnum(recv.getRuntime().getPosix().getpgid((int)arg.convertToInteger().getLongValue()));
    }

    @JRubyMethod(name={"getrlimit"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject getrlimit(IRubyObject recv, IRubyObject arg) {
        throw recv.getRuntime().newNotImplementedError("Process#getrlimit not yet implemented");
    }

    @JRubyMethod(name={"egid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject egid(IRubyObject recv) {
        return recv.getRuntime().newFixnum(recv.getRuntime().getPosix().getegid());
    }

    private static int parseSignalString(Ruby runtime, String value) {
        boolean signalString;
        int startIndex = 0;
        boolean negative = value.startsWith("-");
        if (negative) {
            ++startIndex;
        }
        if (signalString = value.startsWith("SIG", startIndex)) {
            startIndex += 3;
        }
        String signalName = value.substring(startIndex);
        for (int i = 0; i < signals.length; ++i) {
            if (!signals[i].equals(signalName)) continue;
            return negative ? -i : i;
        }
        throw runtime.newArgumentError("unsupported name `SIG" + signalName + "'");
    }

    @JRubyMethod(name={"kill"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject kill(IRubyObject recv, IRubyObject[] args) {
        boolean processGroupKill;
        if (args.length < 2) {
            throw recv.getRuntime().newArgumentError("wrong number of arguments -- kill(sig, pid...)");
        }
        Ruby runtime = recv.getRuntime();
        int signal = args[0] instanceof RubyFixnum ? (int)((RubyFixnum)args[0]).getLongValue() : (args[0] instanceof RubySymbol ? RubyProcess.parseSignalString(runtime, args[0].toString()) : (args[0] instanceof RubyString ? RubyProcess.parseSignalString(runtime, args[0].toString()) : RubyProcess.parseSignalString(runtime, args[0].checkStringType().toString())));
        boolean bl = processGroupKill = signal < 0;
        if (processGroupKill) {
            signal = -signal;
        }
        POSIX posix = runtime.getPosix();
        for (int i = 1; i < args.length; ++i) {
            int pid = RubyNumeric.num2int(args[i]);
            if (pid == 0) {
                pid = runtime.getPosix().getpid();
            }
            posix.kill(processGroupKill ? -pid : pid, signal);
        }
        return runtime.newFixnum(args.length - 1);
    }

    @JRubyMethod(name={"detach"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject detach(ThreadContext context, IRubyObject recv, IRubyObject arg) {
        final int pid = (int)arg.convertToInteger().getLongValue();
        Ruby runtime = recv.getRuntime();
        BlockCallback callback = new BlockCallback(){

            public IRubyObject call(ThreadContext context, IRubyObject[] args, Block block) {
                int[] status = new int[1];
                int result = context.getRuntime().getPosix().waitpid(pid, status, 0);
                return context.getRuntime().newFixnum(result);
            }
        };
        return RubyThread.newInstance(runtime.getThread(), IRubyObject.NULL_ARRAY, CallBlock.newCallClosure(recv, (RubyModule)recv, Arity.NO_ARGUMENTS, callback, context));
    }

    @JRubyMethod(name={"times"}, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject times(IRubyObject recv, Block unusedBlock) {
        Ruby runtime = recv.getRuntime();
        double currentTime = (double)System.currentTimeMillis() / 1000.0;
        double startTime = (double)runtime.getStartTime() / 1000.0;
        RubyFloat zero = runtime.newFloat(0.0);
        return RubyStruct.newStruct(runtime.getTmsStruct(), new IRubyObject[]{runtime.newFloat(currentTime - startTime), zero, zero, zero}, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"pid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject pid(IRubyObject recv) {
        return recv.getRuntime().newFixnum(recv.getRuntime().getPosix().getpid());
    }

    @JRubyMethod(name={"fork"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject fork(ThreadContext context, IRubyObject recv, Block block) {
        return RubyKernel.fork(context, recv, block);
    }

    @JRubyMethod(name={"exit"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject exit(IRubyObject recv, IRubyObject[] args) {
        return RubyKernel.exit(recv, args);
    }

    @JRubyModule(name={"Process::Sys"})
    public static class Sys {
        @JRubyMethod(name={"getegid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject getegid(IRubyObject self) {
            return RubyProcess.egid(self);
        }

        @JRubyMethod(name={"geteuid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject geteuid(IRubyObject self) {
            return RubyProcess.euid(self);
        }

        @JRubyMethod(name={"getgid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject getgid(IRubyObject self) {
            return RubyProcess.gid(self);
        }

        @JRubyMethod(name={"getuid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject getuid(IRubyObject self) {
            return RubyProcess.uid(self);
        }

        @JRubyMethod(name={"setegid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject setegid(IRubyObject recv, IRubyObject arg) {
            return RubyProcess.egid_set(recv, arg);
        }

        @JRubyMethod(name={"seteuid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject seteuid(IRubyObject recv, IRubyObject arg) {
            return RubyProcess.euid_set(recv, arg);
        }

        @JRubyMethod(name={"setgid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject setgid(IRubyObject recv, IRubyObject arg) {
            return RubyProcess.gid_set(recv, arg);
        }

        @JRubyMethod(name={"setuid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject setuid(IRubyObject recv, IRubyObject arg) {
            return RubyProcess.uid_set(recv, arg);
        }
    }

    @JRubyModule(name={"Process::GID"})
    public static class GroupID {
        @JRubyMethod(name={"change_privilege"}, module=true)
        public static IRubyObject change_privilege(IRubyObject self, IRubyObject arg) {
            throw self.getRuntime().newNotImplementedError("Process::GID::change_privilege not implemented yet");
        }

        @JRubyMethod(name={"eid"}, module=true)
        public static IRubyObject eid(IRubyObject self) {
            return RubyProcess.egid(self);
        }

        @JRubyMethod(name={"eid="}, module=true)
        public static IRubyObject eid(IRubyObject self, IRubyObject arg) {
            return RubyProcess.egid_set(self, arg);
        }

        @JRubyMethod(name={"grant_privilege"}, module=true)
        public static IRubyObject grant_privilege(IRubyObject self, IRubyObject arg) {
            throw self.getRuntime().newNotImplementedError("Process::GID::grant_privilege not implemented yet");
        }

        @JRubyMethod(name={"re_exchange"}, module=true)
        public static IRubyObject re_exchange(ThreadContext context, IRubyObject self) {
            return GroupID.switch_rb(context, self, Block.NULL_BLOCK);
        }

        @JRubyMethod(name={"re_exchangeable?"}, module=true)
        public static IRubyObject re_exchangeable_p(IRubyObject self) {
            throw self.getRuntime().newNotImplementedError("Process::GID::re_exchangeable? not implemented yet");
        }

        @JRubyMethod(name={"rid"}, module=true)
        public static IRubyObject rid(IRubyObject self) {
            return RubyProcess.gid(self);
        }

        @JRubyMethod(name={"sid_available?"}, module=true)
        public static IRubyObject sid_available_p(IRubyObject self) {
            throw self.getRuntime().newNotImplementedError("Process::GID::sid_available not implemented yet");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(name={"switch"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject switch_rb(ThreadContext context, IRubyObject self, Block block) {
            Ruby runtime = self.getRuntime();
            int gid = runtime.getPosix().getgid();
            int egid = runtime.getPosix().getegid();
            if (block.isGiven()) {
                try {
                    runtime.getPosix().setegid(gid);
                    runtime.getPosix().setgid(egid);
                    IRubyObject iRubyObject = block.yield(context, runtime.getNil());
                    return iRubyObject;
                }
                finally {
                    runtime.getPosix().setegid(egid);
                    runtime.getPosix().setgid(gid);
                }
            }
            runtime.getPosix().setegid(gid);
            runtime.getPosix().setgid(egid);
            return RubyFixnum.zero(runtime);
        }
    }

    @JRubyModule(name={"Process::UID"})
    public static class UserID {
        @JRubyMethod(name={"change_privilege"}, module=true)
        public static IRubyObject change_privilege(IRubyObject self, IRubyObject arg) {
            throw self.getRuntime().newNotImplementedError("Process::UID::change_privilege not implemented yet");
        }

        @JRubyMethod(name={"eid"}, module=true)
        public static IRubyObject eid(IRubyObject self) {
            return RubyProcess.euid(self);
        }

        @JRubyMethod(name={"eid="}, module=true)
        public static IRubyObject eid(IRubyObject self, IRubyObject arg) {
            return RubyProcess.euid_set(self, arg);
        }

        @JRubyMethod(name={"grant_privilege"}, module=true)
        public static IRubyObject grant_privilege(IRubyObject self, IRubyObject arg) {
            throw self.getRuntime().newNotImplementedError("Process::UID::grant_privilege not implemented yet");
        }

        @JRubyMethod(name={"re_exchange"}, module=true)
        public static IRubyObject re_exchange(ThreadContext context, IRubyObject self) {
            return UserID.switch_rb(context, self, Block.NULL_BLOCK);
        }

        @JRubyMethod(name={"re_exchangeable?"}, module=true)
        public static IRubyObject re_exchangeable_p(IRubyObject self) {
            throw self.getRuntime().newNotImplementedError("Process::UID::re_exchangeable? not implemented yet");
        }

        @JRubyMethod(name={"rid"}, module=true)
        public static IRubyObject rid(IRubyObject self) {
            return RubyProcess.uid(self);
        }

        @JRubyMethod(name={"sid_available?"}, module=true)
        public static IRubyObject sid_available_p(IRubyObject self) {
            throw self.getRuntime().newNotImplementedError("Process::UID::sid_available not implemented yet");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(name={"switch"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject switch_rb(ThreadContext context, IRubyObject self, Block block) {
            Ruby runtime = self.getRuntime();
            int uid = runtime.getPosix().getuid();
            int euid = runtime.getPosix().geteuid();
            if (block.isGiven()) {
                try {
                    runtime.getPosix().seteuid(uid);
                    runtime.getPosix().setuid(euid);
                    IRubyObject iRubyObject = block.yield(context, runtime.getNil());
                    return iRubyObject;
                }
                finally {
                    runtime.getPosix().seteuid(euid);
                    runtime.getPosix().setuid(uid);
                }
            }
            runtime.getPosix().seteuid(uid);
            runtime.getPosix().setuid(euid);
            return RubyFixnum.zero(runtime);
        }
    }

    @JRubyClass(name={"Process::Status"})
    public static class RubyStatus
    extends RubyObject {
        private long status = 0L;
        private static final long EXIT_SUCCESS = 0L;

        public RubyStatus(Ruby runtime, RubyClass metaClass, long status) {
            super(runtime, metaClass);
            this.status = status;
        }

        public static RubyStatus newProcessStatus(Ruby runtime, long status) {
            return new RubyStatus(runtime, runtime.getProcStatus(), status);
        }

        @JRubyMethod(name={"to_int", "pid", "stopped?", "stopsig", "signaled?", "termsig?", "exited?", "coredump?"})
        public IRubyObject not_implemented() {
            String error = "Process::Status#" + this.getRuntime().getCurrentContext().getFrameName() + " not implemented";
            throw this.getRuntime().newNotImplementedError(error);
        }

        @JRubyMethod(name={"&"})
        public IRubyObject not_implemented1(IRubyObject arg) {
            String error = "Process::Status#" + this.getRuntime().getCurrentContext().getFrameName() + " not implemented";
            throw this.getRuntime().newNotImplementedError(error);
        }

        @JRubyMethod
        public IRubyObject exitstatus() {
            return this.getRuntime().newFixnum(this.status);
        }

        @JRubyMethod(name={">>"})
        public IRubyObject op_rshift(IRubyObject other) {
            long shiftValue = other.convertToInteger().getLongValue();
            return this.getRuntime().newFixnum(this.status >> (int)shiftValue);
        }

        @JRubyMethod(name={"=="})
        public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
            return other.callMethod(context, MethodIndex.EQUALEQUAL, "==", this.to_i());
        }

        @JRubyMethod
        public IRubyObject to_i() {
            return this.getRuntime().newFixnum(this.shiftedValue());
        }

        @JRubyMethod
        public IRubyObject to_s() {
            return this.getRuntime().newString(String.valueOf(this.shiftedValue()));
        }

        @JRubyMethod
        public IRubyObject inspect() {
            return this.getRuntime().newString("#<Process::Status: pid=????,exited(" + String.valueOf(this.status) + ")>");
        }

        @JRubyMethod(name={"success?"})
        public IRubyObject success_p() {
            return this.getRuntime().newBoolean(this.status == 0L);
        }

        private long shiftedValue() {
            return this.status << 8;
        }
    }
}

