/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import org.jruby.RubyRegexp;
import org.jruby.ast.DStrNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;

public class DRegexpNode
extends ListNode
implements ILiteralNode {
    private final int options;
    private final boolean once;
    private RubyRegexp onceRegexp;

    public DRegexpNode(ISourcePosition position) {
        this(position, 0, false);
    }

    public DRegexpNode(ISourcePosition position, DStrNode node, int options, boolean once) {
        this(position, options, once);
        this.addAll(node);
    }

    public DRegexpNode(ISourcePosition position, int options, boolean once) {
        super(position, NodeType.DREGEXPNODE);
        this.options = options;
        this.once = once;
    }

    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitDRegxNode(this);
    }

    public boolean getOnce() {
        return this.once;
    }

    public int getOptions() {
        return this.options;
    }

    public RubyRegexp getOnceRegexp() {
        return this.onceRegexp;
    }

    public void setOnceRegexp(RubyRegexp regexp) {
        if (this.once && this.onceRegexp == null) {
            this.onceRegexp = regexp;
        }
    }
}

