/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jruby.ast.CommentNode;
import org.jruby.ast.InvisibleNode;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.IDESourcePosition;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.ISourcePositionHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node
implements ISourcePositionHolder {
    public static final ISourcePosition INVALID_POSITION = new ISourcePosition(){

        @Override
        public String getFile() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getStartLine() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getEndLine() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void adjustStartOffset(int relativeValue) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getStartOffset() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getEndOffset() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public ISourcePosition union(ISourcePosition position) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Collection<CommentNode> getComments() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void setComments(Collection<CommentNode> comments) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    };
    static final List<Node> EMPTY_LIST = new ArrayList<Node>();
    public static final List<CommentNode> EMPTY_COMMENT_LIST = new ArrayList<CommentNode>();
    public final NodeType nodeId;
    private ISourcePosition position;

    public Node(ISourcePosition position, NodeType id) {
        assert (position != null);
        this.position = position;
        this.nodeId = id;
    }

    @Override
    public ISourcePosition getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(ISourcePosition position) {
        this.position = position;
    }

    public abstract Instruction accept(NodeVisitor var1);

    public abstract List<Node> childNodes();

    protected static List<Node> createList(Node ... nodes) {
        ArrayList<Node> list = new ArrayList<Node>();
        for (Node node : nodes) {
            if (node == null) continue;
            list.add(node);
        }
        return list;
    }

    public String toString() {
        return this.getNodeName() + "[]";
    }

    protected String getNodeName() {
        String name = this.getClass().getName();
        int i = name.lastIndexOf(46);
        String nodeType = name.substring(i + 1);
        return nodeType;
    }

    public void addComment(CommentNode comment) {
        Collection<CommentNode> comments = this.position.getComments();
        if (comments == null) {
            comments = new ArrayList<CommentNode>();
            this.position.setComments(comments);
        }
        comments.add(comment);
    }

    public void addComments(Collection<CommentNode> moreComments) {
        Collection<CommentNode> comments = this.position.getComments();
        if (comments == EMPTY_COMMENT_LIST) {
            comments = new ArrayList<CommentNode>();
            this.position.setComments(comments);
        }
        comments.addAll(moreComments);
    }

    public Collection<CommentNode> getComments() {
        return this.position.getComments();
    }

    public boolean hasComments() {
        return this.getComments() != EMPTY_COMMENT_LIST;
    }

    public ISourcePosition getPositionIncludingComments() {
        if (!this.hasComments()) {
            return this.position;
        }
        String fileName = this.position.getFile();
        int startOffset = this.position.getStartOffset();
        int endOffset = this.position.getEndOffset();
        int startLine = this.position.getStartLine();
        int endLine = this.position.getEndLine();
        IDESourcePosition commentIncludingPos = new IDESourcePosition(fileName, startLine, endLine, startOffset, endOffset);
        for (CommentNode comment : this.getComments()) {
            commentIncludingPos = IDESourcePosition.combinePosition(commentIncludingPos, comment.getPosition());
        }
        return commentIncludingPos;
    }

    public boolean isInvisible() {
        return this instanceof InvisibleNode;
    }
}

