/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.Node;
import org.jruby.ast.executable.Script;
import org.jruby.ast.util.SexpMaker;
import org.jruby.compiler.ASTCompiler;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.MethodCompiler;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DefaultMethod;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.util.ClassCache;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;

public class JITCompiler {
    public static final boolean USE_CACHE = true;

    public static void runJIT(DefaultMethod method, Ruby runtime, ThreadContext context, String name) {
        Set<Script> jittedMethods = runtime.getJittedMethods();
        RubyInstanceConfig instanceConfig = runtime.getInstanceConfig();
        ClassCache classCache = instanceConfig.getClassCache();
        if (method.getCallCount() < 0) {
            return;
        }
        try {
            method.setCallCount(method.getCallCount() + 1);
            if (method.getCallCount() >= instanceConfig.getJitThreshold()) {
                int methodCount;
                if (classCache.isFull()) {
                    method.setCallCount(-1);
                    return;
                }
                JITClassGenerator generator = new JITClassGenerator(name, method, context);
                String key = SexpMaker.create(name, method.getArgsNode(), method.getBodyNode());
                Class sourceClass = instanceConfig.getClassCache().cacheClassByKey(key, generator);
                if (sourceClass == null) {
                    method.setCallCount(-1);
                    return;
                }
                Script jitCompiledScript = (Script)sourceClass.newInstance();
                jittedMethods.add(jitCompiledScript);
                if (instanceConfig.getJitLogEvery() > 0 && (methodCount = jittedMethods.size()) % instanceConfig.getJitLogEvery() == 0) {
                    JITCompiler.log(method, name, "live compiled methods: " + methodCount, new String[0]);
                }
                if (instanceConfig.isJitLogging()) {
                    JITCompiler.log(method, name, "done jitting", new String[0]);
                }
                method.setJITCallConfig(generator.callConfig());
                method.setJITCompiledScript(jitCompiledScript);
                method.setCallCount(-1);
            }
        }
        catch (Throwable t) {
            if (instanceConfig.isJitLoggingVerbose()) {
                JITCompiler.log(method, name, "could not compile", t.getMessage());
            }
            method.setCallCount(-1);
        }
    }

    private static String calculateFilename(ArgsNode argsNode, Node bodyNode) {
        if (bodyNode != null) {
            return bodyNode.getPosition().getFile();
        }
        if (argsNode != null) {
            return argsNode.getPosition().getFile();
        }
        return "__eval__";
    }

    static void log(DefaultMethod method, String name, String message, String ... reason) {
        String className = method.getImplementationClass().getBaseName();
        if (className == null) {
            className = "<anon class>";
        }
        System.err.print(message + ":" + className + "." + name);
        if (reason.length > 0) {
            System.err.print(" because of: \"");
            for (int i = 0; i < reason.length; ++i) {
                System.err.print(reason[i]);
            }
            System.err.print('\"');
        }
        System.err.println("");
    }

    public static class JITClassGenerator
    implements ClassCache.ClassGenerator {
        private StandardASMCompiler asmCompiler;
        private DefaultMethod method;
        private StaticScope staticScope;
        private Node bodyNode;
        private ArgsNode argsNode;
        private CallConfiguration jitCallConfig;
        private byte[] bytecode;
        private String name;

        public JITClassGenerator(String name, DefaultMethod method, ThreadContext context) {
            this.method = method;
            String packageName = "ruby/jit/" + JavaNameMangler.mangleFilenameForClasspath(method.getPosition().getFile());
            String cleanName = packageName + "/" + JavaNameMangler.mangleStringForCleanJavaIdentifier(name);
            this.bodyNode = method.getBodyNode();
            this.argsNode = method.getArgsNode();
            String filename = JITCompiler.calculateFilename(this.argsNode, this.bodyNode);
            this.staticScope = method.getStaticScope();
            this.asmCompiler = new StandardASMCompiler(cleanName + method.hashCode() + "_" + context.hashCode(), filename);
        }

        protected void compile() {
            MethodCompiler methodCompiler;
            if (this.bytecode != null) {
                return;
            }
            this.asmCompiler.startScript(this.staticScope);
            final ASTCompiler compiler = new ASTCompiler();
            CompilerCallback args = new CompilerCallback(){

                public void call(MethodCompiler context) {
                    compiler.compileArgs(JITClassGenerator.this.argsNode, context);
                }
            };
            ASTInspector inspector = new ASTInspector();
            inspector.inspect(this.argsNode);
            inspector.inspect(this.bodyNode);
            if (this.bodyNode != null) {
                methodCompiler = this.asmCompiler.startMethod("__file__", args, this.staticScope, inspector);
                compiler.compile(this.bodyNode, methodCompiler);
            } else if (this.argsNode != null && (this.argsNode.getRequiredArgsCount() > 0 || this.argsNode.getOptionalArgsCount() > 0)) {
                methodCompiler = this.asmCompiler.startMethod("__file__", args, this.staticScope, inspector);
                methodCompiler.loadNil();
            } else {
                methodCompiler = this.asmCompiler.startMethod("__file__", null, this.staticScope, inspector);
                methodCompiler.loadNil();
                this.jitCallConfig = CallConfiguration.NO_FRAME_NO_SCOPE;
            }
            methodCompiler.endMethod();
            this.asmCompiler.endScript(false, false, false);
            if (this.jitCallConfig == null) {
                this.jitCallConfig = inspector.hasClosure() || inspector.hasScopeAwareMethods() ? CallConfiguration.FRAME_AND_SCOPE : CallConfiguration.FRAME_ONLY;
            }
            this.bytecode = this.asmCompiler.getClassByteArray();
            this.name = CodegenUtils.c(this.asmCompiler.getClassname());
        }

        public byte[] bytecode() {
            this.compile();
            return this.bytecode;
        }

        public String name() {
            this.compile();
            return this.name;
        }

        public CallConfiguration callConfig() {
            this.compile();
            return this.jitCallConfig;
        }
    }
}

