/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer.yacc;

import java.io.IOException;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.StrNode;
import org.jruby.lexer.yacc.LexerSource;
import org.jruby.lexer.yacc.RubyYaccLexer;
import org.jruby.lexer.yacc.StrTerm;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.lexer.yacc.Token;
import org.jruby.util.ByteList;

public class StringTerm
extends StrTerm {
    private int flags;
    private final char begin;
    private final char end;
    private int nest;

    public StringTerm(int flags, int begin, int end) {
        this.flags = flags;
        this.begin = (char)begin;
        this.end = (char)end;
        this.nest = 0;
    }

    public int parseString(RubyYaccLexer lexer, LexerSource src) throws IOException {
        boolean spaceSeen = false;
        if (this.flags == -1) {
            lexer.setValue(new Token("\"", lexer.getPosition()));
            return 374;
        }
        int c = src.read();
        if ((this.flags & 8) != 0 && Character.isWhitespace(c)) {
            while (Character.isWhitespace(c = src.read())) {
            }
            spaceSeen = true;
        }
        if (c == this.end && this.nest == 0) {
            if ((this.flags & 8) != 0) {
                this.flags = -1;
                lexer.getPosition();
                return 32;
            }
            if ((this.flags & 4) != 0) {
                lexer.setValue(new RegexpNode(src.getPosition(), ByteList.create(""), this.parseRegexpFlags(src)));
                return 315;
            }
            lexer.setValue(new Token("\"", lexer.getPosition()));
            return 374;
        }
        if (spaceSeen) {
            src.unread(c);
            lexer.getPosition();
            return 32;
        }
        if (this.begin == '\u0000' && this.flags == 0) {
            ByteList buffer = new ByteList();
            src.unread(c);
            if (this.parseSimpleStringIntoBuffer(src, buffer) == -1) {
                throw new SyntaxException(SyntaxException.PID.STRING_HITS_EOF, src.getPosition(), "unterminated string meets end of file", new Object[0]);
            }
            lexer.setValue(new StrNode(lexer.getPosition(), buffer));
            return 312;
        }
        ByteList buffer = new ByteList();
        if ((this.flags & 2) != 0 && c == 35) {
            c = src.read();
            switch (c) {
                case 36: 
                case 64: {
                    src.unread(c);
                    lexer.setValue(new Token("#" + c, lexer.getPosition()));
                    return 373;
                }
                case 123: {
                    lexer.setValue(new Token("#" + c, lexer.getPosition()));
                    return 372;
                }
            }
            buffer.append((byte)35);
        }
        src.unread(c);
        if (this.parseStringIntoBuffer(lexer, src, buffer) == -1) {
            throw new SyntaxException(SyntaxException.PID.STRING_HITS_EOF, src.getPosition(), "unterminated string meets end of file", new Object[0]);
        }
        lexer.setValue(new StrNode(lexer.getPosition(), buffer));
        return 312;
    }

    private int parseRegexpFlags(LexerSource src) throws IOException {
        int kcode = 0;
        int options = 0;
        StringBuilder unknownFlags = new StringBuilder(10);
        int c = src.read();
        while (c != -1 && Character.isLetter(c)) {
            switch (c) {
                case 105: {
                    options |= 1;
                    break;
                }
                case 120: {
                    options |= 2;
                    break;
                }
                case 109: {
                    options |= 4;
                    break;
                }
                case 111: {
                    options |= 0x80;
                    break;
                }
                case 110: {
                    kcode = 16;
                    break;
                }
                case 101: {
                    kcode = 32;
                    break;
                }
                case 115: {
                    kcode = 48;
                    break;
                }
                case 117: {
                    kcode = 64;
                    break;
                }
                case 106: {
                    options |= 0x100;
                    break;
                }
                default: {
                    unknownFlags.append((char)c);
                }
            }
            c = src.read();
        }
        src.unread(c);
        if (unknownFlags.length() != 0) {
            throw new SyntaxException(SyntaxException.PID.REGEXP_UNKNOWN_OPTION, src.getPosition(), "unknown regexp option" + (unknownFlags.length() > 1 ? "s" : "") + " - " + unknownFlags.toString(), unknownFlags.toString());
        }
        return options | kcode;
    }

    public int parseSimpleStringIntoBuffer(LexerSource src, ByteList buffer) throws IOException {
        int c;
        while ((c = src.read()) != -1) {
            if (c == this.end) {
                src.unread(c);
                break;
            }
            if (c == 92 && ((c = src.read()) == 10 || c != this.end) && c != 92) {
                buffer.append(92);
            }
            buffer.append(c);
        }
        return c;
    }

    public int parseStringIntoBuffer(RubyYaccLexer lexer, LexerSource src, ByteList buffer) throws IOException {
        int c;
        boolean regexp;
        boolean qwords = (this.flags & 8) != 0;
        boolean expand = (this.flags & 2) != 0;
        boolean escape = (this.flags & 1) != 0;
        boolean bl = regexp = (this.flags & 4) != 0;
        block4: while ((c = src.read()) != -1) {
            block14: {
                block17: {
                    block16: {
                        block15: {
                            block13: {
                                if (this.begin == '\u0000' || c != this.begin) break block13;
                                ++this.nest;
                                break block14;
                            }
                            if (c != this.end) break block15;
                            if (this.nest == 0) {
                                src.unread(c);
                                break;
                            }
                            --this.nest;
                            break block14;
                        }
                        if (c != 35 || !expand || src.peek(10)) break block16;
                        int c2 = src.read();
                        if (c2 == 36 || c2 == 64 || c2 == 123) {
                            src.unread(c2);
                            src.unread(c);
                            break;
                        }
                        src.unread(c2);
                        break block14;
                    }
                    if (c != 92) break block17;
                    c = src.read();
                    switch (c) {
                        case 10: {
                            if (qwords) break;
                            if (expand) continue block4;
                            buffer.append(92);
                            break;
                        }
                        case 92: {
                            if (escape) {
                                buffer.append(c);
                                break;
                            }
                            break block14;
                        }
                        default: {
                            if (regexp) {
                                src.unread(c);
                                this.parseEscapeIntoBuffer(src, buffer);
                                continue block4;
                            }
                            if (expand) {
                                src.unread(c);
                                if (escape) {
                                    buffer.append(92);
                                }
                                c = lexer.readEscape();
                                break;
                            }
                            if (qwords && Character.isWhitespace(c)) break;
                            if (c != this.end && (this.begin == '\u0000' || c != this.begin)) {
                                buffer.append(92);
                                break;
                            }
                            break block14;
                        }
                    }
                    break block14;
                }
                if (qwords && Character.isWhitespace(c)) {
                    src.unread(c);
                    break;
                }
            }
            buffer.append(c);
        }
        return c;
    }

    private void escaped(LexerSource src, ByteList buffer) throws IOException {
        int c = src.read();
        switch (c) {
            case 92: {
                this.parseEscapeIntoBuffer(src, buffer);
                break;
            }
            case -1: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, src.getPosition(), "Invalid escape character syntax", new Object[0]);
            }
            default: {
                buffer.append(c);
            }
        }
    }

    private void parseEscapeIntoBuffer(LexerSource src, ByteList buffer) throws IOException {
        int c = src.read();
        block0 : switch (c) {
            case 10: {
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                buffer.append(92);
                buffer.append(c);
                for (int i = 0; i < 2; ++i) {
                    c = src.read();
                    if (c == -1) {
                        throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, src.getPosition(), "Invalid escape character syntax", new Object[0]);
                    }
                    if (!RubyYaccLexer.isOctChar(c)) {
                        src.unread(c);
                        break block0;
                    }
                    buffer.append(c);
                }
                break;
            }
            case 120: {
                buffer.append(92);
                buffer.append(c);
                c = src.read();
                if (!RubyYaccLexer.isHexChar(c)) {
                    throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, src.getPosition(), "Invalid escape character syntax", new Object[0]);
                }
                buffer.append(c);
                c = src.read();
                if (RubyYaccLexer.isHexChar(c)) {
                    buffer.append(c);
                    break;
                }
                src.unread(c);
                break;
            }
            case 77: {
                c = src.read();
                if (c != 45) {
                    throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, src.getPosition(), "Invalid escape character syntax", new Object[0]);
                }
                buffer.append(new byte[]{92, 77, 45});
                this.escaped(src, buffer);
                break;
            }
            case 67: {
                c = src.read();
                if (c != 45) {
                    throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, src.getPosition(), "Invalid escape character syntax", new Object[0]);
                }
                buffer.append(new byte[]{92, 67, 45});
                this.escaped(src, buffer);
                break;
            }
            case 99: {
                buffer.append(new byte[]{92, 99});
                this.escaped(src, buffer);
                break;
            }
            case -1: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, src.getPosition(), "Invalid escape character syntax", new Object[0]);
            }
            default: {
                if (c != 92 || c != this.end) {
                    buffer.append(92);
                }
                buffer.append(c);
            }
        }
    }
}

