/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.drools.model;

import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.messaging.RobustInOnly;
import javax.xml.namespace.NamespaceContext;
import org.apache.servicemix.drools.model.Fault;
import org.apache.servicemix.drools.model.Message;

public class Exchange {
    public static final String IN_ONLY = "InOnly";
    public static final String ROBUST_IN_ONLY = "RobustInOnly";
    public static final String IN_OUT = "InOut";
    public static final String IN_OPTIONAL_OUT = "InOptionalOut";
    public static final String ACTIVE = "Active";
    public static final String ERROR = "Error";
    public static final String DONE = "Done";
    public static final String IN_MESSAGE = "in";
    public static final String OUT_MESSAGE = "out";
    private final MessageExchange exchange;
    private Message in;
    private Message out;
    private Message fault;
    private NamespaceContext namespaceContext;

    public Exchange(MessageExchange exchange, NamespaceContext namespaceContext) {
        NormalizedMessage msg;
        this.exchange = exchange;
        this.namespaceContext = namespaceContext;
        if (this.in == null) {
            msg = exchange.getMessage(IN_MESSAGE);
            Message message = this.in = msg != null ? new Message(msg, this.namespaceContext) : null;
        }
        if (this.out == null) {
            msg = exchange.getMessage(OUT_MESSAGE);
            Message message = this.out = msg != null ? new Message(msg, this.namespaceContext) : null;
        }
        if (this.fault == null) {
            msg = exchange.getFault();
            this.fault = msg != null ? new Fault((javax.jbi.messaging.Fault)msg, this.namespaceContext) : null;
        }
    }

    public MessageExchange getInternalExchange() {
        return this.exchange;
    }

    public String getMep() {
        if (this.exchange instanceof InOnly) {
            return IN_ONLY;
        }
        if (this.exchange instanceof RobustInOnly) {
            return ROBUST_IN_ONLY;
        }
        if (this.exchange instanceof InOut) {
            return IN_OUT;
        }
        if (this.exchange instanceof InOptionalOut) {
            return IN_OPTIONAL_OUT;
        }
        return this.exchange.getPattern().toString();
    }

    public String getStatus() {
        if (this.exchange.getStatus() == ExchangeStatus.ACTIVE) {
            return ACTIVE;
        }
        if (this.exchange.getStatus() == ExchangeStatus.DONE) {
            return DONE;
        }
        if (this.exchange.getStatus() == ExchangeStatus.ERROR) {
            return ERROR;
        }
        throw new IllegalStateException("Unkown exchange status");
    }

    public String getOperation() {
        return this.exchange.getOperation() != null ? this.exchange.getOperation().toString() : null;
    }

    public Object getProperty(String name) {
        return this.exchange.getProperty(name);
    }

    public void setProperty(String name, Object value) {
        this.exchange.setProperty(name, value);
    }

    public Message getIn() {
        return this.in;
    }

    public Message getOut() {
        return this.out;
    }

    public Message getFault() {
        return this.fault;
    }

    protected Message getMessage(String name) {
        NormalizedMessage msg = this.exchange.getMessage(name);
        return msg != null ? new Message(msg, this.namespaceContext) : null;
    }
}

