/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.drools.model;

import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.EndpointSupport;
import org.apache.servicemix.common.util.MessageUtil;
import org.apache.servicemix.common.util.URIResolver;
import org.apache.servicemix.drools.DroolsEndpoint;
import org.apache.servicemix.drools.model.Exchange;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.drools.FactHandle;
import org.drools.WorkingMemory;

public class JbiHelper {
    private DroolsEndpoint endpoint;
    private Exchange exchange;
    private WorkingMemory memory;
    private FactHandle exchangeFactHandle;
    private boolean exchangeHandled = false;

    public JbiHelper(DroolsEndpoint endpoint, MessageExchange exchange, WorkingMemory memory) {
        this.endpoint = endpoint;
        this.exchange = new Exchange(exchange, endpoint.getNamespaceContext());
        this.memory = memory;
        this.exchangeFactHandle = this.memory.insert((Object)this.exchange);
    }

    public DroolsEndpoint getEndpoint() {
        return this.endpoint;
    }

    public ComponentContext getContext() {
        return this.endpoint.getContext();
    }

    public DeliveryChannel getChannel() throws MessagingException {
        return this.getContext().getDeliveryChannel();
    }

    public Exchange getExchange() {
        return this.exchange;
    }

    public Log getLogger() {
        return LogFactory.getLog((String)this.memory.getRuleBase().getPackages()[0].getName());
    }

    public void route(String uri) throws MessagingException {
        Source src = null;
        this.routeTo(src, uri);
    }

    public void routeTo(String content, String uri) throws MessagingException {
        if (content == null) {
            this.routeTo(this.exchange.getInternalExchange().getMessage("in").getContent(), uri);
        } else {
            this.routeTo((Source)new StringSource(content), uri);
        }
    }

    public void routeTo(Source content, String uri) throws MessagingException {
        MessageExchange me = this.exchange.getInternalExchange();
        NormalizedMessage in = null;
        if (content == null) {
            in = me.getMessage("in");
        } else {
            in = me.createMessage();
            in.setContent(content);
        }
        MessageExchange newMe = this.getChannel().createExchangeFactory().createExchange(me.getPattern());
        URIResolver.configureExchange((MessageExchange)newMe, (ComponentContext)this.getContext(), (String)uri);
        MessageUtil.transferToIn((NormalizedMessage)in, (MessageExchange)newMe);
        String key = EndpointSupport.getKey((Endpoint)this.endpoint);
        newMe.setProperty("org.apache.servicemix.senderEndpoint", (Object)key);
        newMe.setProperty("org.apache.servicemix.correlationId", (Object)DroolsEndpoint.getCorrelationId(this.exchange.getInternalExchange()));
        newMe.setProperty("org.apache.servicemix.drools.correlation_id", (Object)me.getExchangeId());
        this.getChannel().send(newMe);
    }

    public void routeToDefault(String content) throws MessagingException {
        this.routeTo(content, this.endpoint.getDefaultRouteURI());
    }

    public void routeToDefault(Source content) throws MessagingException {
        this.routeTo(content, this.endpoint.getDefaultRouteURI());
    }

    public void fault(String content) throws Exception {
        MessageExchange me = this.exchange.getInternalExchange();
        if (me instanceof InOnly) {
            me.setError(new Exception(content));
            this.getChannel().send(me);
        } else {
            Fault fault = me.createFault();
            fault.setContent((Source)new StringSource(content));
            me.setFault(fault);
            this.getChannel().send(me);
        }
        this.exchangeHandled = true;
    }

    public void fault(Source content) throws Exception {
        MessageExchange me = this.exchange.getInternalExchange();
        if (me instanceof InOnly) {
            me.setError(new Exception(new SourceTransformer().toString(content)));
            this.getChannel().send(me);
        } else {
            Fault fault = me.createFault();
            fault.setContent(content);
            me.setFault(fault);
            this.getChannel().send(me);
        }
        this.exchangeHandled = true;
    }

    public void answer(String content) throws Exception {
        this.answer((Source)new StringSource(content));
    }

    public void answer(Source content) throws Exception {
        MessageExchange me = this.exchange.getInternalExchange();
        NormalizedMessage out = me.createMessage();
        out.setContent(content);
        me.setMessage(out, "out");
        this.getChannel().send(me);
        this.exchangeHandled = true;
        this.update();
    }

    public void update() {
        this.memory.update(this.exchangeFactHandle, (Object)this.exchange);
    }

    public boolean isExchangeHandled() {
        return this.exchangeHandled;
    }
}

