/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.Routes;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultLifecycleStrategy;
import org.apache.camel.management.DefaultInstrumentationAgent;
import org.apache.camel.management.InstrumentationLifecycleStrategy;
import org.apache.camel.model.Block;
import org.apache.camel.model.ExceptionType;
import org.apache.camel.model.IdentifiedType;
import org.apache.camel.model.InterceptType;
import org.apache.camel.model.ProceedType;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.model.RouteBuilderRef;
import org.apache.camel.model.RouteContainer;
import org.apache.camel.model.RouteType;
import org.apache.camel.model.dataformat.DataFormatsType;
import org.apache.camel.processor.interceptor.Debugger;
import org.apache.camel.processor.interceptor.Delayer;
import org.apache.camel.processor.interceptor.TraceFormatter;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.InstrumentationAgent;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.Registry;
import org.apache.camel.spring.CamelBeanPostProcessor;
import org.apache.camel.spring.CamelJMXAgentType;
import org.apache.camel.spring.CamelProxyFactoryType;
import org.apache.camel.spring.CamelServiceExporterType;
import org.apache.camel.spring.CamelTemplateFactoryBean;
import org.apache.camel.spring.EndpointFactoryBean;
import org.apache.camel.spring.RouteBuilderFinder;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResolverUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="camelContext")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CamelContextFactoryBean
extends IdentifiedType
implements RouteContainer,
FactoryBean,
InitializingBean,
DisposableBean,
ApplicationContextAware,
ApplicationListener {
    private static final Log LOG = LogFactory.getLog(CamelContextFactoryBean.class);
    @XmlAttribute(required=false)
    @Deprecated
    private Boolean useJmx = Boolean.TRUE;
    @XmlAttribute(required=false)
    private Boolean autowireRouteBuilders = Boolean.TRUE;
    @XmlAttribute(required=false)
    private Boolean trace;
    @XmlAttribute(required=false)
    private Long delay;
    @XmlAttribute(required=false)
    private String errorHandlerRef;
    @XmlAttribute(required=false)
    private Boolean shouldStartContext = Boolean.TRUE;
    @XmlElement(name="package", required=false)
    private String[] packages = new String[0];
    @XmlElement(name="jmxAgent", type=CamelJMXAgentType.class, required=false)
    private CamelJMXAgentType camelJMXAgent;
    @XmlElements(value={@XmlElement(name="beanPostProcessor", type=CamelBeanPostProcessor.class, required=false), @XmlElement(name="template", type=CamelTemplateFactoryBean.class, required=false), @XmlElement(name="proxy", type=CamelProxyFactoryType.class, required=false), @XmlElement(name="export", type=CamelServiceExporterType.class, required=false)})
    private List beans;
    @XmlElement(name="routeBuilderRef", required=false)
    private List<RouteBuilderRef> builderRefs = new ArrayList<RouteBuilderRef>();
    @XmlElement(name="endpoint", required=false)
    private List<EndpointFactoryBean> endpoints;
    @XmlElement(name="dataFormats", required=false)
    private DataFormatsType dataFormats;
    @XmlElement(name="intercept", required=false)
    private List<InterceptType> intercepts = new ArrayList<InterceptType>();
    @XmlElement(name="route", required=false)
    private List<RouteType> routes = new ArrayList<RouteType>();
    @XmlTransient
    private SpringCamelContext context;
    @XmlTransient
    private RouteBuilder routeBuilder;
    @XmlTransient
    private List<Routes> additionalBuilders = new ArrayList<Routes>();
    @XmlTransient
    private ApplicationContext applicationContext;
    @XmlTransient
    private ClassLoader contextClassLoaderOnStart = Thread.currentThread().getContextClassLoader();
    @XmlTransient
    private BeanPostProcessor beanPostProcessor;

    public Object getObject() throws Exception {
        return this.getContext();
    }

    public Class getObjectType() {
        return SpringCamelContext.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public ClassLoader getContextClassLoaderOnStart() {
        return this.contextClassLoaderOnStart;
    }

    public List<Routes> getAdditionalBuilders() {
        return this.additionalBuilders;
    }

    public void afterPropertiesSet() throws Exception {
        Registry registry;
        LifecycleStrategy lifecycleStrategy;
        Delayer delayer;
        Tracer tracer;
        Debugger debugger = this.getBeanForType(Debugger.class);
        if (debugger != null) {
            this.getContext().addInterceptStrategy((InterceptStrategy)debugger);
        }
        if ((tracer = this.getBeanForType(Tracer.class)) != null) {
            TraceFormatter formatter = this.getBeanForType(TraceFormatter.class);
            if (formatter != null) {
                tracer.setFormatter(formatter);
            }
            this.getContext().addInterceptStrategy((InterceptStrategy)tracer);
        }
        if ((delayer = this.getBeanForType(Delayer.class)) != null) {
            this.getContext().addInterceptStrategy((InterceptStrategy)delayer);
        }
        if ((lifecycleStrategy = this.getBeanForType(LifecycleStrategy.class)) != null) {
            this.getContext().setLifecycleStrategy(lifecycleStrategy);
        }
        if ((registry = this.getBeanForType(Registry.class)) != null) {
            this.getContext().setRegistry(registry);
        }
        if (this.beanPostProcessor != null) {
            if (this.beanPostProcessor instanceof ApplicationContextAware) {
                ((ApplicationContextAware)this.beanPostProcessor).setApplicationContext(this.applicationContext);
            }
            if (this.beanPostProcessor instanceof CamelBeanPostProcessor) {
                ((CamelBeanPostProcessor)this.beanPostProcessor).setCamelContext(this.getContext());
            }
        }
        for (RouteType route : this.routes) {
            for (InterceptType intercept : this.intercepts) {
                ProcessorType processorType;
                ArrayList<ProcessorType> outputs = new ArrayList<ProcessorType>();
                ArrayList<ProcessorType> exceptionHandlers = new ArrayList<ProcessorType>();
                for (ProcessorType output : route.getOutputs()) {
                    if (output instanceof ExceptionType) {
                        exceptionHandlers.add(output);
                        continue;
                    }
                    outputs.add(output);
                }
                route.clearOutput();
                route.getOutputs().addAll(exceptionHandlers);
                InterceptType proxy = intercept.createProxy();
                route.addOutput((ProcessorType)proxy);
                route.pushBlock((Block)proxy.getProceed());
                int outputsSize = proxy.getOutputs().size();
                if (outputsSize <= 0 || !((processorType = (ProcessorType)proxy.getOutputs().get(outputsSize - 1)) instanceof ProceedType)) continue;
                route.getOutputs().addAll(outputs);
            }
        }
        if (this.dataFormats != null) {
            this.getContext().setDataFormats(this.dataFormats.asMap());
        }
        this.getContext().addRouteDefinitions(this.routes);
        if (!this.isJmxEnabled() || this.camelJMXAgent != null && this.camelJMXAgent.isDisabled().booleanValue()) {
            LOG.debug((Object)"JMXAgent disabled");
            this.getContext().setLifecycleStrategy((LifecycleStrategy)new DefaultLifecycleStrategy());
        } else if (this.camelJMXAgent != null) {
            LOG.debug((Object)"JMXAgent enabled");
            if (lifecycleStrategy != null) {
                LOG.warn((Object)"lifecycleStrategy will be overriden by InstrumentationLifecycleStrategy");
            }
            DefaultInstrumentationAgent agent = new DefaultInstrumentationAgent();
            agent.setConnectorPort(this.camelJMXAgent.getConnectorPort());
            agent.setCreateConnector(this.camelJMXAgent.isCreateConnector());
            agent.setMBeanObjectDomainName(this.camelJMXAgent.getMbeanObjectDomainName());
            agent.setMBeanServerDefaultDomain(this.camelJMXAgent.getMbeanServerDefaultDomain());
            agent.setRegistryPort(this.camelJMXAgent.getRegistryPort());
            agent.setServiceUrlPath(this.camelJMXAgent.getServiceUrlPath());
            agent.setUsePlatformMBeanServer(this.camelJMXAgent.isUsePlatformMBeanServer());
            this.getContext().setLifecycleStrategy((LifecycleStrategy)new InstrumentationLifecycleStrategy((InstrumentationAgent)agent));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Found JAXB created routes: " + this.getRoutes()));
        }
        this.findRouteBuilders();
        this.installRoutes();
    }

    private <T> T getBeanForType(Class<T> clazz) {
        ApplicationContext parentContext;
        Object bean = null;
        String[] names = this.getApplicationContext().getBeanNamesForType(clazz, true, true);
        if (names.length == 1) {
            bean = this.getApplicationContext().getBean(names[0], clazz);
        }
        if (bean == null && (parentContext = this.getApplicationContext().getParent()) != null && (names = parentContext.getBeanNamesForType(clazz, true, true)).length == 1) {
            bean = parentContext.getBean(names[0], clazz);
        }
        return (T)bean;
    }

    public void destroy() throws Exception {
        this.getContext().stop();
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Publishing spring-event: " + event));
        }
        if (event instanceof ContextRefreshedEvent) {
            try {
                LOG.debug((Object)"Starting the context now!");
                this.getContext().start();
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
            }
        }
    }

    public SpringCamelContext getContext() throws Exception {
        if (this.context == null) {
            this.context = this.createContext();
        }
        return this.context;
    }

    public void setContext(SpringCamelContext context) {
        this.context = context;
    }

    public List<RouteType> getRoutes() {
        return this.routes;
    }

    public void setRoutes(List<RouteType> routes) {
        this.routes = routes;
    }

    public List<InterceptType> getIntercepts() {
        return this.intercepts;
    }

    public void setIntercepts(List<InterceptType> intercepts) {
        this.intercepts = intercepts;
    }

    public RouteBuilder getRouteBuilder() {
        return this.routeBuilder;
    }

    public void setRouteBuilder(RouteBuilder routeBuilder) {
        this.routeBuilder = routeBuilder;
    }

    public void setRouteBuilders(RouteBuilder[] builders) {
        for (RouteBuilder builder : builders) {
            this.additionalBuilders.add((Routes)builder);
        }
    }

    public ApplicationContext getApplicationContext() {
        if (this.applicationContext == null) {
            throw new IllegalArgumentException("No applicationContext has been injected!");
        }
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public String[] getPackages() {
        return this.packages;
    }

    public void setPackages(String[] packages) {
        this.packages = packages;
    }

    public void setBeanPostProcessor(BeanPostProcessor postProcessor) {
        this.beanPostProcessor = postProcessor;
    }

    public BeanPostProcessor getBeanPostProcessor() {
        return this.beanPostProcessor;
    }

    public boolean isJmxEnabled() {
        return this.useJmx;
    }

    public Boolean getUseJmx() {
        return this.useJmx;
    }

    public void setUseJmx(Boolean useJmx) {
        this.useJmx = useJmx;
    }

    public void setCamelJMXAgent(CamelJMXAgentType agent) {
        this.camelJMXAgent = agent;
    }

    public Boolean getTrace() {
        return this.trace;
    }

    public void setTrace(Boolean trace) {
        this.trace = trace;
    }

    public Long getDelay() {
        return this.delay;
    }

    public void setDelay(Long delay) {
        this.delay = delay;
    }

    public CamelJMXAgentType getCamelJMXAgent() {
        return this.camelJMXAgent;
    }

    public List<RouteBuilderRef> getBuilderRefs() {
        return this.builderRefs;
    }

    public void setBuilderRefs(List<RouteBuilderRef> builderRefs) {
        this.builderRefs = builderRefs;
    }

    public void setAutowireRouteBuilders(Boolean autowireRouteBuilders) {
        this.autowireRouteBuilders = autowireRouteBuilders;
    }

    public String getErrorHandlerRef() {
        return this.errorHandlerRef;
    }

    public void setErrorHandlerRef(String errorHandlerRef) {
        this.errorHandlerRef = errorHandlerRef;
    }

    public Boolean getShouldStartContext() {
        return this.shouldStartContext;
    }

    public void setShouldStartContext(Boolean shouldStartContext) {
        this.shouldStartContext = shouldStartContext;
    }

    protected SpringCamelContext createContext() {
        SpringCamelContext ctx = new SpringCamelContext(this.getApplicationContext());
        ctx.setName(this.getId());
        if (this.trace != null) {
            ctx.setTrace(this.trace);
        }
        if (this.delay != null) {
            ctx.setDelay(this.delay);
        }
        if (this.errorHandlerRef != null) {
            ErrorHandlerBuilder errorHandlerBuilder = (ErrorHandlerBuilder)this.getApplicationContext().getBean(this.errorHandlerRef, ErrorHandlerBuilder.class);
            if (errorHandlerBuilder == null) {
                throw new IllegalArgumentException("Could not find bean: " + this.errorHandlerRef);
            }
            ctx.setErrorHandlerBuilder(errorHandlerBuilder);
        }
        if (this.shouldStartContext != null) {
            ctx.setShouldStartContext(this.shouldStartContext);
        }
        return ctx;
    }

    protected void installRoutes() throws Exception {
        Map builders;
        if (this.autowireRouteBuilders != null && this.autowireRouteBuilders.booleanValue() && (builders = this.getApplicationContext().getBeansOfType(RouteBuilder.class, true, true)) != null) {
            for (Object builder : builders.values()) {
                this.getContext().addRoutes((Routes)((RouteBuilder)builder));
            }
        }
        for (Routes routeBuilder : this.additionalBuilders) {
            this.getContext().addRoutes(routeBuilder);
        }
        if (this.routeBuilder != null) {
            this.getContext().addRoutes((Routes)this.routeBuilder);
        }
        if (this.builderRefs != null) {
            for (RouteBuilderRef builderRef : this.builderRefs) {
                Object builder;
                builder = builderRef.createRouteBuilder((CamelContext)this.getContext());
                this.getContext().addRoutes((Routes)builder);
            }
        }
    }

    protected void findRouteBuilders() throws Exception, InstantiationException {
        if (this.getPackages() != null && this.getPackages().length > 0) {
            RouteBuilderFinder finder = new RouteBuilderFinder(this.getContext(), this.getPackages(), this.getContextClassLoaderOnStart(), this.getBeanPostProcessor(), this.createResolverUtil());
            finder.appendBuilders(this.getAdditionalBuilders());
        }
    }

    protected ResolverUtil createResolverUtil() {
        return new ResolverUtil();
    }

    public void setDataFormats(DataFormatsType dataFormats) {
        this.dataFormats = dataFormats;
    }

    public DataFormatsType getDataFormats() {
        return this.dataFormats;
    }
}

