/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.ansi;

import org.apache.geronimo.gshell.ansi.ANSI;
import org.apache.geronimo.gshell.ansi.Code;

public class Buffer {
    private final StringBuffer buff = new StringBuffer();
    public Boolean ansiEnabled;
    public boolean autoClear;

    public Buffer(Boolean ansiEnabled, boolean autoClear) {
        this.ansiEnabled = ansiEnabled;
        this.autoClear = autoClear;
    }

    public Buffer() {
        this(null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        try {
            String string = this.buff.toString();
            return string;
        }
        finally {
            if (this.autoClear) {
                this.clear();
            }
        }
    }

    public boolean isAnsiEnabled() {
        if (this.ansiEnabled == null) {
            this.ansiEnabled = ANSI.isEnabled();
        }
        return this.ansiEnabled;
    }

    public void clear() {
        this.buff.setLength(0);
    }

    public int size() {
        return this.buff.length();
    }

    public Buffer append(String text) {
        this.buff.append(text);
        return this;
    }

    public Buffer append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public Buffer attrib(int code) {
        if (this.isAnsiEnabled()) {
            this.buff.append(Code.attrib(code));
        }
        return this;
    }

    public Buffer attrib(String text, int code) {
        assert (text != null);
        if (this.isAnsiEnabled()) {
            this.buff.append(Code.attrib(code)).append(text).append(Code.attrib(0));
        } else {
            this.buff.append(text);
        }
        return this;
    }

    public Buffer attrib(String text, String codeName) {
        return this.attrib(text, Code.forName(codeName));
    }
}

