/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.i18n;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.geronimo.gshell.i18n.MessageSource;
import org.codehaus.plexus.util.StringUtils;

public class ResourceBundleMessageSource
implements MessageSource {
    private final String[] bundleNames;
    private ResourceBundle[] cachedBundles;

    public ResourceBundleMessageSource(String[] names) {
        assert (names != null);
        assert (names.length != 0);
        this.bundleNames = names;
    }

    public ResourceBundleMessageSource(String name) {
        this(new String[]{name});
    }

    private static String[] classNames(Class[] types) {
        assert (types != null);
        assert (types.length != 0);
        String[] names = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            assert (types[i] != null);
            names[i] = types[i].getName();
        }
        return names;
    }

    public ResourceBundleMessageSource(Class[] types) {
        this(ResourceBundleMessageSource.classNames(types));
    }

    public ResourceBundleMessageSource(Class type) {
        this(new String[]{type.getName()});
    }

    private ResourceBundle[] createBundles() {
        ResourceBundle[] bundles = new ResourceBundle[this.bundleNames.length];
        for (int i = 0; i < this.bundleNames.length; ++i) {
            assert (this.bundleNames[i] != null);
            bundles[i] = ResourceBundle.getBundle(this.bundleNames[i]);
        }
        return bundles;
    }

    private ResourceBundle[] getBundles() {
        if (this.cachedBundles == null) {
            this.cachedBundles = this.createBundles();
        }
        return this.cachedBundles;
    }

    public String getMessage(String code) {
        assert (code != null);
        for (ResourceBundle bundle : this.getBundles()) {
            try {
                return bundle.getString(code);
            }
            catch (MissingResourceException ignore) {
            }
        }
        throw new ResourceNotFoundException(code);
    }

    public String format(String code, Object ... args) {
        assert (args != null);
        String pattern = this.getMessage(code);
        return MessageFormat.format(pattern, args);
    }

    public Object getProperty(String name) {
        return this.getMessage(name);
    }

    private static String notFoundMessage(String code, String[] bundleNames) {
        return "Resource not found for code: " + code + " in bundles: " + StringUtils.join(bundleNames, ", ");
    }

    public class ResourceNotFoundException
    extends RuntimeException {
        public ResourceNotFoundException(String code) {
            super(ResourceBundleMessageSource.notFoundMessage(code, ResourceBundleMessageSource.this.bundleNames));
        }
    }
}

