/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.plugin;

import java.net.URI;
import org.apache.geronimo.gshell.command.Command;
import org.apache.geronimo.gshell.common.tostring.ReflectionToStringBuilder;
import org.apache.geronimo.gshell.common.tostring.ToStringStyle;
import org.apache.geronimo.gshell.descriptor.CommandDescriptor;
import org.apache.geronimo.gshell.descriptor.CommandParameter;
import org.apache.geronimo.gshell.descriptor.CommandRequirement;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;

public class ComponentDescriptorAdapter
extends ComponentDescriptor {
    private final CommandDescriptor command;

    public ComponentDescriptorAdapter(CommandDescriptor command) {
        assert (command != null);
        this.command = command;
        URI source = command.getSource();
        if (source != null) {
            this.setSource(source.toString());
        }
        this.setDescription(command.getDescription());
        this.setAlias(null);
        this.setRole(Command.class.getName());
        this.setRoleHint(command.getId());
        this.setImplementation(command.getImplementation());
        this.setVersion(command.getVersion());
        this.setComponentType(null);
        this.setLifecycleHandler(null);
        this.setComponentProfile(null);
        this.setComponentFactory(null);
        this.setComponentComposer(null);
        this.setComponentConfigurator(null);
        this.setRealmId(null);
        this.setIsolatedRealm(false);
        this.setInstantiationStrategy("per-lookup");
        if (command.hasParameters()) {
            XmlPlexusConfiguration root = new XmlPlexusConfiguration("configuration");
            for (CommandParameter param : command.getParameters()) {
                XmlPlexusConfiguration child = new XmlPlexusConfiguration(param.getName());
                child.setValue(param.getValue());
                root.addChild((PlexusConfiguration)child);
            }
            this.setConfiguration((PlexusConfiguration)root);
        }
        if (command.hasRequirements()) {
            for (CommandRequirement requirement : command.getRequirements()) {
                this.addRequirement(this.translate(requirement));
            }
        }
    }

    private ComponentRequirement translate(CommandRequirement source) {
        assert (source != null);
        ComponentRequirement requirement = new ComponentRequirement();
        requirement.setRole(source.getType());
        requirement.setRoleHint(source.getId());
        requirement.setFieldName(source.getName());
        requirement.setFieldMappingType(null);
        return requirement;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public CommandDescriptor getCommand() {
        return this.command;
    }
}

