/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.registry;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.geronimo.gshell.command.Command;
import org.apache.geronimo.gshell.descriptor.CommandDescriptor;
import org.apache.geronimo.gshell.plugin.CommandDiscoveryListener;
import org.apache.geronimo.gshell.plugin.PlexusCommandWrapper;
import org.apache.geronimo.gshell.registry.CommandRegistry;
import org.apache.geronimo.gshell.registry.DuplicateRegistrationException;
import org.apache.geronimo.gshell.registry.NotRegisteredException;
import org.apache.geronimo.gshell.registry.RegistryException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=CommandRegistry.class)
public class DefaultCommandRegistry
implements CommandRegistry {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Requirement
    private PlexusContainer container;
    @Requirement
    private CommandDiscoveryListener collector;
    private Map<String, Command> commands = new HashMap<String, Command>();

    @Override
    public void register(Command command) throws DuplicateRegistrationException {
        assert (command != null);
        String id = command.getId();
        if (this.commands.containsKey(id)) {
            throw new DuplicateRegistrationException(id);
        }
        this.commands.put(id, command);
        this.log.debug("Registered: {}", (Object)id);
    }

    private void ensureRegistered(String id) throws RegistryException {
        assert (id != null);
        if (!this.commands.containsKey(id)) {
            CommandDescriptor descriptor = this.collector.getCommandDescriptor(id);
            if (descriptor == null) {
                throw new NotRegisteredException(id);
            }
            this.log.debug("Registering command id: {}", (Object)id);
            this.register(new PlexusCommandWrapper(this.container, descriptor));
        }
    }

    @Override
    public void unregister(Command command) throws RegistryException {
        assert (command != null);
        String id = command.getId();
        this.ensureRegistered(id);
        this.commands.remove(id);
        this.log.debug("Unregistered: {}", (Object)id);
    }

    @Override
    public Command lookup(String id) throws RegistryException {
        assert (id != null);
        this.ensureRegistered(id);
        return this.commands.get(id);
    }

    @Override
    public Collection<Command> commands() {
        return Collections.unmodifiableCollection(this.commands.values());
    }
}

