/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.remote.client.proxy;

import java.util.concurrent.atomic.AtomicReference;
import jline.Terminal;
import org.apache.geronimo.gshell.ErrorNotification;
import org.apache.geronimo.gshell.ExitNotification;
import org.apache.geronimo.gshell.ansi.Renderer;
import org.apache.geronimo.gshell.command.IO;
import org.apache.geronimo.gshell.console.Console;
import org.apache.geronimo.gshell.console.JLineConsole;
import org.apache.geronimo.gshell.remote.RemoteShell;
import org.apache.geronimo.gshell.remote.client.SpringRshClient;
import org.apache.geronimo.gshell.remote.client.proxy.RemoteBrandingProxy;
import org.apache.geronimo.gshell.remote.client.proxy.RemoteEnvironmentProxy;
import org.apache.geronimo.gshell.remote.client.proxy.RemoteHistoryProxy;
import org.apache.geronimo.gshell.remote.client.proxy.SpringRemoteShellInfoProxy;
import org.apache.geronimo.gshell.shell.Environment;
import org.apache.geronimo.gshell.shell.InteractiveShell;
import org.apache.geronimo.gshell.shell.ShellInfo;
import org.apache.geronimo.gshell.whisper.stream.StreamFeeder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringRemoteShellProxy
implements RemoteShell,
InteractiveShell {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private SpringRshClient client;
    private IO io;
    private Terminal terminal;
    private StreamFeeder outputFeeder;
    private boolean opened;
    private RemoteEnvironmentProxy env;
    private SpringRemoteShellInfoProxy shellInfo;
    private RemoteHistoryProxy history;
    private RemoteBrandingProxy branding;

    public SpringRemoteShellProxy(SpringRshClient client, IO io, Terminal terminal) throws Exception {
        assert (client != null);
        assert (io != null);
        assert (terminal != null);
        this.client = client;
        this.io = io;
        this.terminal = terminal;
        client.openShell();
        this.env = new RemoteEnvironmentProxy(client);
        this.shellInfo = new SpringRemoteShellInfoProxy(client);
        this.history = new RemoteHistoryProxy(client);
        this.branding = new RemoteBrandingProxy(client);
        this.outputFeeder = new StreamFeeder(client.getInputStream(), io.outputStream);
        this.outputFeeder.createThread().start();
        this.opened = true;
    }

    public Environment getEnvironment() {
        this.ensureOpened();
        return this.env;
    }

    public ShellInfo getShellInfo() {
        this.ensureOpened();
        return this.shellInfo;
    }

    private void ensureOpened() {
        if (!this.opened) {
            throw new IllegalStateException("Remote shell proxy has been closed");
        }
    }

    public boolean isOpened() {
        return this.opened;
    }

    public void close() {
        try {
            this.client.closeShell();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            this.outputFeeder.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.opened = false;
    }

    public Object execute(String line) throws Exception {
        this.ensureOpened();
        return this.client.execute(line);
    }

    public Object execute(Object ... args) throws Exception {
        this.ensureOpened();
        return this.client.execute(args);
    }

    public Object execute(String path, Object[] args) throws Exception {
        this.ensureOpened();
        return this.client.execute(path, args);
    }

    public Object execute(Object[][] commands) throws Exception {
        this.ensureOpened();
        return this.client.execute(commands);
    }

    public void run(Object ... args) throws Exception {
        assert (args != null);
        this.ensureOpened();
        this.log.debug("Starting interactive console; args: {}", args);
        final AtomicReference exitNotifHolder = new AtomicReference();
        final AtomicReference lastResultHolder = new AtomicReference();
        Console.Executor executor = new Console.Executor(){

            public Console.Executor.Result execute(String line) throws Exception {
                assert (line != null);
                try {
                    Object result = SpringRemoteShellProxy.this.execute(line);
                    lastResultHolder.set(result);
                }
                catch (ExitNotification n) {
                    exitNotifHolder.set(n);
                    return Console.Executor.Result.STOP;
                }
                return Console.Executor.Result.CONTINUE;
            }
        };
        JLineConsole console = new JLineConsole(executor, this.io, this.terminal);
        console.setPrompter(new Console.Prompter(){
            Renderer renderer = new Renderer();

            public String prompt() {
                String userName = SpringRemoteShellProxy.this.shellInfo.getUserName();
                String hostName = SpringRemoteShellProxy.this.shellInfo.getInstanceName() != null ? SpringRemoteShellProxy.this.shellInfo.getInstanceName() : "unknown";
                String path = "/";
                return this.renderer.render("@|bold " + userName + "|@" + hostName + ":@|bold " + path + "|> ");
            }
        });
        console.setErrorHandler(new Console.ErrorHandler(){

            public Console.ErrorHandler.Result handleError(Throwable error) {
                assert (error != null);
                SpringRemoteShellProxy.this.displayError(error);
                return Console.ErrorHandler.Result.CONTINUE;
            }
        });
        if (args.length != 0) {
            this.execute(args);
        }
        console.run();
        ExitNotification n = (ExitNotification)exitNotifHolder.get();
        if (n != null) {
            throw n;
        }
    }

    private void displayError(Throwable error) {
        assert (error != null);
        Throwable cause = error;
        if (error instanceof ErrorNotification) {
            cause = error.getCause();
        }
        this.io.err.print("@|bold,red ERROR| ");
        this.io.err.print(cause.getClass().getSimpleName());
        this.io.err.println(": @|bold,red " + cause.getMessage() + "|");
        String stackTraceProperty = System.getProperty("gshell.show.stacktrace");
        boolean stackTraceFlag = false;
        if (stackTraceProperty != null) {
            stackTraceFlag = stackTraceProperty.trim().equals("true");
        }
        if (this.io.isDebug()) {
            this.log.debug(error.toString(), error);
        } else if (this.io.isVerbose() || stackTraceFlag) {
            StackTraceElement[] trace = cause.getStackTrace();
            StringBuffer buff = new StringBuffer();
            for (StackTraceElement e : trace) {
                buff.append("        @|bold at| ").append(e.getClassName()).append(".").append(e.getMethodName()).append(" (@|bold ");
                buff.append(e.isNativeMethod() ? "Native Method" : (e.getFileName() != null && e.getLineNumber() != -1 ? e.getFileName() + ":" + e.getLineNumber() : (e.getFileName() != null ? e.getFileName() : "Unknown Source")));
                buff.append("|)");
                this.io.err.println(buff);
                buff.setLength(0);
            }
        }
    }
}

