/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.remote.crypto;

import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.codehaus.plexus.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=CryptoContext.class)
public class CryptoContext {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private String transformation = "RSA";
    private String provider;
    private final KeyPair keyPair;

    public CryptoContext() throws Exception {
        KeyPairGenerator keyGen = this.createKeyPairGenerator();
        keyGen.initialize(1024);
        this.keyPair = keyGen.genKeyPair();
    }

    public CryptoContext(String transformation, String provider) throws Exception {
        this();
        this.transformation = transformation;
        this.provider = provider;
    }

    public PublicKey getPublicKey() {
        return this.keyPair.getPublic();
    }

    private byte[] codec(int mode, Key key, byte[] bytes) throws Exception {
        assert (key != null);
        assert (bytes != null);
        Cipher cipher = this.createCipher();
        cipher.init(mode, key);
        return cipher.doFinal(bytes);
    }

    public byte[] encrypt(Key key, byte[] bytes) throws Exception {
        return this.codec(1, key, bytes);
    }

    public byte[] encrypt(byte[] bytes) throws Exception {
        return this.encrypt(this.keyPair.getPublic(), bytes);
    }

    public byte[] decrypt(Key key, byte[] bytes) throws Exception {
        return this.codec(2, key, bytes);
    }

    public byte[] decrypt(byte[] bytes) throws Exception {
        return this.decrypt(this.keyPair.getPrivate(), bytes);
    }

    public PublicKey deserializePublicKey(byte[] bytes) throws Exception {
        assert (bytes != null);
        X509EncodedKeySpec spec = new X509EncodedKeySpec(bytes);
        KeyFactory keyFactory = this.createKeyFactory();
        return keyFactory.generatePublic(spec);
    }

    private KeyPairGenerator createKeyPairGenerator() throws Exception {
        if (this.provider != null) {
            return KeyPairGenerator.getInstance(this.transformation, this.provider);
        }
        return KeyPairGenerator.getInstance(this.transformation);
    }

    private Cipher createCipher() throws Exception {
        if (this.provider != null) {
            return Cipher.getInstance(this.transformation, this.provider);
        }
        return Cipher.getInstance(this.transformation);
    }

    private KeyFactory createKeyFactory() throws Exception {
        if (this.provider != null) {
            return KeyFactory.getInstance(this.transformation, this.provider);
        }
        return KeyFactory.getInstance(this.transformation);
    }
}

