/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.remote.server;

import java.net.URI;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.geronimo.gshell.common.Duration;
import org.apache.geronimo.gshell.remote.server.handler.ServerMessageHandler;
import org.apache.geronimo.gshell.remote.server.handler.ServerSessionContext;
import org.apache.geronimo.gshell.remote.server.timeout.TimeoutManager;
import org.apache.geronimo.gshell.whisper.message.MessageHandler;
import org.apache.geronimo.gshell.whisper.transport.Session;
import org.apache.geronimo.gshell.whisper.transport.TransportFactoryLocator;
import org.apache.geronimo.gshell.whisper.transport.TransportServer;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.demux.DemuxingIoHandler;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=RshServer.class, instantiationStrategy="per-lookup")
public class RshServer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Requirement
    private TimeoutManager timeoutManager;
    @Requirement
    private TransportFactoryLocator locator;
    private TransportServer server;
    @Requirement(role=ServerMessageHandler.class)
    private List<ServerMessageHandler> handlers;
    public static final Duration AUTH_TIMEOUT = new Duration(10L, TimeUnit.SECONDS);

    public RshServer() {
    }

    public RshServer(TimeoutManager timeoutManager, TransportFactoryLocator locator, List<ServerMessageHandler> handlers) {
        this.timeoutManager = timeoutManager;
        this.locator = locator;
        this.handlers = handlers;
    }

    public void bind(URI location) throws Exception {
        Object factory = this.locator.locate(location);
        this.server = factory.bind(location, (IoHandler)new Handler());
        this.log.debug("Bound to: {}", (Object)location);
    }

    public void close() {
        this.server.close();
    }

    private class Handler
    extends DemuxingIoHandler {
        public Handler() throws Exception {
            if (RshServer.this.handlers.isEmpty()) {
                throw new Error("No message handlers were discovered");
            }
            for (ServerMessageHandler handler : RshServer.this.handlers) {
                this.register(handler);
            }
        }

        public void register(MessageHandler handler) {
            assert (handler != null);
            Class type = handler.getType();
            RshServer.this.log.debug("Registering handler: {} -> {}", (Object)type.getSimpleName(), (Object)handler);
            this.addMessageHandler(type, handler);
        }

        public void messageReceived(IoSession session, Object message) throws Exception {
            assert (session != null);
            assert (message != null);
            super.messageReceived(session, message);
        }

        public void sessionOpened(final IoSession session) throws Exception {
            assert (session != null);
            final Session s = Session.BINDER.lookup(session);
            ServerSessionContext context = ServerSessionContext.BINDER.bind(session, new ServerSessionContext());
            RshServer.this.log.debug("Created session context: {}", (Object)context);
            RshServer.this.timeoutManager.scheduleTimeout(s, AUTH_TIMEOUT, new Runnable(){

                public void run() {
                    RshServer.this.log.error("Timeout waiting for handshake from: {}", (Object)s);
                    session.close();
                }
            });
        }

        public void sessionClosed(IoSession session) throws Exception {
            assert (session != null);
            ServerSessionContext context = ServerSessionContext.BINDER.unbind(session);
            RshServer.this.log.debug("Removed session context: {}", (Object)context);
        }
    }
}

