/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.spring;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.geronimo.gshell.CommandLine;
import org.apache.geronimo.gshell.CommandLineBuilder;
import org.apache.geronimo.gshell.ErrorNotification;
import org.apache.geronimo.gshell.ExecutingVisitor;
import org.apache.geronimo.gshell.command.CommandExecutor;
import org.apache.geronimo.gshell.parser.ASTCommandLine;
import org.apache.geronimo.gshell.parser.CommandLineParser;
import org.apache.geronimo.gshell.parser.ParseException;
import org.apache.geronimo.gshell.shell.Environment;

public class SpringCommandLineBuilder
implements CommandLineBuilder {
    private CommandLineParser parser = new CommandLineParser();
    private CommandExecutor executor;
    private Environment environment;

    public void setExecutor(CommandExecutor executor) {
        this.executor = executor;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ASTCommandLine parse(String input) throws ParseException {
        ASTCommandLine cl;
        assert (input != null);
        StringReader reader = new StringReader(input);
        try {
            cl = this.parser.parse(reader);
        }
        finally {
            try {
                ((Reader)reader).close();
            }
            catch (IOException e) {}
        }
        return cl;
    }

    public CommandLine create(String commandLine) throws ParseException {
        assert (commandLine != null);
        if (commandLine.trim().length() == 0) {
            throw new IllegalArgumentException("Command line is empty");
        }
        try {
            final ExecutingVisitor visitor = new ExecutingVisitor(this.executor, this.environment);
            final ASTCommandLine root = this.parse(commandLine);
            return new CommandLine(){

                public Object execute() throws Exception {
                    return root.jjtAccept(visitor, null);
                }
            };
        }
        catch (Exception e) {
            throw new ErrorNotification(e);
        }
    }
}

