/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.whisper.stream;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamFeeder
implements Runnable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final InputStream input;
    private final OutputStream output;
    private volatile boolean running;
    private static final AtomicInteger THREAD_COUNTER = new AtomicInteger(0);

    public StreamFeeder(InputStream input, OutputStream output) {
        assert (input != null);
        assert (output != null);
        this.input = input;
        this.output = output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.running = true;
        this.log.debug("Running");
        try {
            int b;
            while (this.running && (b = this.input.read()) != -1) {
                this.output.write(b);
            }
        }
        catch (Throwable e) {
            this.log.error("Feed failure: " + e, e);
        }
        finally {
            this.close();
        }
        this.log.debug("Stopped");
    }

    public boolean isRunning() {
        return this.running;
    }

    public void close() {
        this.running = false;
        this.log.debug("Closed");
    }

    public Thread createThread() {
        Thread t = new Thread((Runnable)this, this.getClass().getSimpleName() + "-" + THREAD_COUNTER.getAndIncrement());
        t.setDaemon(true);
        return t;
    }
}

