/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.whisper.transport.base;

import java.net.URI;
import org.apache.geronimo.gshell.whisper.transport.Transport;
import org.apache.geronimo.gshell.whisper.transport.TransportFactory;
import org.apache.geronimo.gshell.whisper.transport.TransportServer;
import org.apache.geronimo.gshell.whisper.transport.base.BaseTransport;
import org.apache.geronimo.gshell.whisper.transport.base.BaseTransportServer;
import org.apache.mina.common.IoHandler;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Requirement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseTransportFactory<T extends BaseTransport, TC extends Transport.Configuration, S extends BaseTransportServer, SC extends TransportServer.Configuration>
implements TransportFactory {
    @Requirement
    protected PlexusContainer container;
    private final String scheme;

    protected BaseTransportFactory(String scheme) {
        assert (scheme != null);
        this.scheme = scheme;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public T connect(URI remote, URI local, TC config) throws Exception {
        assert (remote != null);
        assert (config != null);
        BaseTransport transport = (BaseTransport)this.container.lookup(Transport.class, this.scheme);
        transport.setConfiguration((Transport.Configuration)config);
        transport.connect(remote, local);
        return (T)transport;
    }

    @Override
    public T connect(URI remote, URI local, IoHandler handler) throws Exception {
        assert (remote != null);
        assert (handler != null);
        BaseTransport transport = (BaseTransport)this.container.lookup(Transport.class, this.scheme);
        transport.getConfiguration().setHandler(handler);
        transport.connect(remote, local);
        return (T)transport;
    }

    @Override
    public S bind(URI location, SC config) throws Exception {
        assert (location != null);
        assert (config != null);
        BaseTransportServer server = (BaseTransportServer)this.container.lookup(TransportServer.class, this.scheme);
        server.setConfiguration((TransportServer.Configuration)config);
        server.bind(location);
        return (S)server;
    }

    @Override
    public S bind(URI location, IoHandler handler) throws Exception {
        assert (location != null);
        assert (handler != null);
        BaseTransportServer server = (BaseTransportServer)this.container.lookup(TransportServer.class, this.scheme);
        server.getConfiguration().setHandler(handler);
        server.bind(location);
        return (S)server;
    }
}

