/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.whisper.transport.base;

import java.net.URI;
import org.apache.geronimo.gshell.whisper.transport.Transport;
import org.apache.geronimo.gshell.whisper.transport.TransportFactory;
import org.apache.geronimo.gshell.whisper.transport.TransportServer;
import org.apache.geronimo.gshell.whisper.transport.base.BaseTransport;
import org.apache.geronimo.gshell.whisper.transport.base.BaseTransportServer;
import org.apache.mina.common.IoHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SpringBaseTransportFactory<T extends BaseTransport, TC extends Transport.Configuration, S extends BaseTransportServer, SC extends TransportServer.Configuration>
implements TransportFactory {
    private String scheme;

    protected SpringBaseTransportFactory(String scheme) {
        this.scheme = scheme;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public T connect(URI remote, URI local, TC config) throws Exception {
        assert (remote != null);
        assert (config != null);
        T transport = this.createTransport();
        ((BaseTransport)transport).setConfiguration((Transport.Configuration)config);
        ((BaseTransport)transport).connect(remote, local);
        return transport;
    }

    @Override
    public T connect(URI remote, URI local, IoHandler handler) throws Exception {
        assert (remote != null);
        assert (handler != null);
        T transport = this.createTransport();
        ((BaseTransport)transport).getConfiguration().setHandler(handler);
        ((BaseTransport)transport).connect(remote, local);
        return transport;
    }

    @Override
    public S bind(URI location, SC config) throws Exception {
        assert (location != null);
        assert (config != null);
        S server = this.createTransportServer();
        ((BaseTransportServer)server).setConfiguration((TransportServer.Configuration)config);
        ((BaseTransportServer)server).bind(location);
        return server;
    }

    @Override
    public S bind(URI location, IoHandler handler) throws Exception {
        assert (location != null);
        assert (handler != null);
        S server = this.createTransportServer();
        ((BaseTransportServer)server).getConfiguration().setHandler(handler);
        ((BaseTransportServer)server).bind(location);
        return server;
    }

    protected abstract T createTransport();

    protected abstract S createTransportServer();
}

