/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.ConsumeMime;
import javax.ws.rs.Encoded;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.provider.FormValidator;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.FormUtils;
import org.apache.cxf.jaxrs.utils.multipart.AttachmentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConsumeMime(value={"application/x-www-form-urlencoded", "multipart/form-data"})
@Provider
public class FormEncodingReaderProvider
implements MessageBodyReader<Object> {
    private static final MediaType MULTIPART_FORM_DATA = MediaType.valueOf((String)"multipart/form-data");
    private FormValidator validator;
    @Context
    private MessageContext mc;
    private String attachmentDir;
    private String attachmentThreshold;

    public void setAttachmentDirectory(String dir) {
        this.attachmentDir = dir;
    }

    public void setAttachmentThreshold(String threshold) {
        this.attachmentThreshold = threshold;
    }

    public void setValidator(FormValidator formValidator) {
        this.validator = formValidator;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations) {
        return MultivaluedMap.class.isAssignableFrom(type) || this.mediaTypeSupported() && MultipartBody.class.isAssignableFrom(type);
    }

    public Object readFrom(Class<Object> clazz, Type genericType, Annotation[] annotations, MediaType type, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        try {
            if (MultipartBody.class.isAssignableFrom(clazz)) {
                return AttachmentUtils.getMultipartBody(this.mc);
            }
            MultivaluedMap<String, String> params = this.createMap(clazz);
            this.populateMap(params, is, type, AnnotationUtils.getAnnotation(annotations, Encoded.class) == null);
            this.validateMap(params);
            return params;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    protected MultivaluedMap<String, String> createMap(Class<?> clazz) throws Exception {
        if (clazz == MultivaluedMap.class) {
            return new MetadataMap<String, String>();
        }
        return (MultivaluedMap)clazz.newInstance();
    }

    protected void populateMap(MultivaluedMap<String, String> params, InputStream is, MediaType mt, boolean decode) {
        if (mt.isCompatible(MULTIPART_FORM_DATA)) {
            MultipartBody body = AttachmentUtils.getMultipartBody(this.mc, this.attachmentDir, this.attachmentThreshold);
            FormUtils.populateMapFromMultipart(params, body, decode);
        } else {
            FormUtils.populateMapFromString(params, FormUtils.readBody(is), decode);
        }
    }

    protected void validateMap(MultivaluedMap<String, String> params) {
        if (this.validator != null) {
            this.validator.validate(params);
        }
    }

    private boolean mediaTypeSupported() {
        if (this.mc == null) {
            return false;
        }
        MediaType mt = this.mc.getHttpHeaders().getMediaType();
        return mt.isCompatible(MULTIPART_FORM_DATA);
    }
}

