/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.osgi;

import org.apache.geronimo.gshell.clp.Option;
import org.apache.geronimo.gshell.command.Command;
import org.apache.geronimo.gshell.command.annotation.CommandComponent;
import org.apache.geronimo.gshell.support.OsgiCommandSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.startlevel.StartLevel;

@CommandComponent(id="osgi:list-bundles", description="List bundles")
public class ListBundles
extends OsgiCommandSupport {
    @Option(name="-l", description="Show locations")
    boolean showLoc;
    @Option(name="-s", description="Show symbolic name")
    boolean showSymbolic;
    @Option(name="-u", description="Show update")
    boolean showUpdate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        ServiceReference ref = this.getBundleContext().getServiceReference(StartLevel.class.getName());
        StartLevel sl = null;
        if (ref != null) {
            sl = (StartLevel)this.getBundleContext().getService(ref);
        }
        if (sl == null) {
            this.io.out.println("StartLevel service is unavailable.");
        }
        try {
            Bundle[] bundles = this.getBundleContext().getBundles();
            if (bundles != null) {
                if (sl != null) {
                    this.io.out.println("START LEVEL " + sl.getStartLevel());
                }
                String msg = " Name";
                if (this.showLoc) {
                    msg = " Location";
                } else if (this.showSymbolic) {
                    msg = " Symbolic name";
                } else if (this.showUpdate) {
                    msg = " Update location";
                }
                String level = sl == null ? "" : "  Level ";
                this.io.out.println("   ID   State       " + level + msg);
                for (int i = 0; i < bundles.length; ++i) {
                    String name = (String)bundles[i].getHeaders().get("Bundle-Name");
                    name = name == null ? bundles[i].getSymbolicName() : name;
                    String string = name = name == null ? bundles[i].getLocation() : name;
                    if (this.showLoc) {
                        name = bundles[i].getLocation();
                    } else if (this.showSymbolic) {
                        name = bundles[i].getSymbolicName();
                        name = name == null ? "<no symbolic name>" : name;
                    } else if (this.showUpdate) {
                        name = (String)bundles[i].getHeaders().get("Bundle-UpdateLocation");
                        name = name == null ? bundles[i].getLocation() : name;
                    }
                    String version = (String)bundles[i].getHeaders().get("Bundle-Version");
                    name = !this.showLoc && !this.showUpdate && version != null ? name + " (" + version + ")" : name;
                    long l = bundles[i].getBundleId();
                    String id = String.valueOf(l);
                    level = sl == null ? "1" : String.valueOf(sl.getBundleStartLevel(bundles[i]));
                    while (level.length() < 5) {
                        level = " " + level;
                    }
                    while (id.length() < 4) {
                        id = " " + id;
                    }
                    this.io.out.println("[" + id + "] [" + this.getStateString(bundles[i].getState()) + "] [" + level + "] " + name);
                }
            } else {
                this.io.out.println("There are no installed bundles.");
            }
            Command.Result result = SUCCESS;
            return result;
        }
        finally {
            if (ref != null) {
                this.getBundleContext().ungetService(ref);
            }
        }
    }

    public String getStateString(int i) {
        if (i == 32) {
            return "Active     ";
        }
        if (i == 2) {
            return "Installed  ";
        }
        if (i == 4) {
            return "Resolved   ";
        }
        if (i == 8) {
            return "Starting   ";
        }
        if (i == 16) {
            return "Stopping   ";
        }
        return "Unknown    ";
    }
}

