/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.osgi;

import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.command.Command;
import org.apache.geronimo.gshell.command.annotation.CommandComponent;
import org.apache.geronimo.gshell.support.OsgiCommandSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

@CommandComponent(id="osgi:refresh", description="Refresh bundle")
public class RefreshBundle
extends OsgiCommandSupport {
    @Argument(required=false)
    Long id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        ServiceReference ref = this.getBundleContext().getServiceReference(PackageAdmin.class.getName());
        if (ref == null) {
            this.io.out.println("PackageAdmin service is unavailable.");
            return FAILURE;
        }
        try {
            PackageAdmin pa = (PackageAdmin)this.getBundleContext().getService(ref);
            if (pa == null) {
                this.io.out.println("PackageAdmin service is unavailable.");
                Command.Result result = FAILURE;
                return result;
            }
            if (this.id == null) {
                pa.refreshPackages(null);
            } else {
                Bundle bundle = this.getBundleContext().getBundle(this.id.longValue());
                if (bundle == null) {
                    this.io.out.println("Bundle " + this.id + " not found");
                    Command.Result result = FAILURE;
                    return result;
                }
                pa.refreshPackages(new Bundle[]{bundle});
            }
        }
        finally {
            this.getBundleContext().ungetService(ref);
        }
        return SUCCESS;
    }
}

