/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.Serializable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.ComparisonKey;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.value.AtomicValue;

public class EmptyGreatestComparer
implements AtomicComparer,
Serializable {
    private AtomicComparer baseComparer;

    public EmptyGreatestComparer(AtomicComparer baseComparer) {
        this.baseComparer = baseComparer;
    }

    public AtomicComparer getBaseComparer() {
        return this.baseComparer;
    }

    public AtomicComparer provideContext(XPathContext context) {
        AtomicComparer newBase = this.baseComparer.provideContext(context);
        if (newBase != this.baseComparer) {
            return new EmptyGreatestComparer(newBase);
        }
        return this;
    }

    public int compareAtomicValues(AtomicValue a, AtomicValue b) throws NoDynamicContextException {
        if (a == null) {
            if (b == null) {
                return 0;
            }
            return 1;
        }
        if (b == null) {
            return -1;
        }
        if (a.isNaN()) {
            return b.isNaN() ? 0 : 1;
        }
        if (b.isNaN()) {
            return -1;
        }
        return this.baseComparer.compareAtomicValues(a, b);
    }

    public boolean comparesEqual(AtomicValue a, AtomicValue b) throws NoDynamicContextException {
        return a == null && b == null || this.baseComparer.comparesEqual(a, b);
    }

    public ComparisonKey getComparisonKey(AtomicValue a) throws NoDynamicContextException {
        return a == null ? new ComparisonKey(15, "()") : this.baseComparer.getComparisonKey(a);
    }
}

